;******************Procedure view_text version 1_0******************************
;Procedure 	View_text,c,h,f,mag,err
;;
;Function   Saving ASCII copies of individual xxx spectra to /temp directory
;           file name 1234567M###.txt where xxx is the fiber number
;
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;
;Report to log:Saving ASCII copy of median of ### sky fibers to c:/xxx/xxx
;              Saving ASCII copies of xxx spectra to c:/xxx/xxx
;
;Procedures called:
;printl       - Prints text message to log file
;
;*****************************Procedure***************************************
pro view_text,c,h,f,mag,err
;***************count number of sky, star and circle set up spectra***********
index = where(f.type eq 'S' and f.line gt 0,nsky)
index = where(f.type eq 'P' and f.line gt 0,nstar)
index = where(f.type eq 'C' and f.line gt 0,ncirc)
;***************save median sky spectrum to ASCII file***********************
if nsky gt 1 then begin
   printl,c.log,'Saving ASCII copy of median of '+strtrim(nsky,2)+$
      ' sky fibers to '+c.pdir+c.ptemp
   openw,nw,c.pdir+c.ptemp+strtrim(c.starfile,2)+'_MSKY'+'.txt', /get_lun
   for j = 0,c.nwl-1 do printf,nw,mag(0,j),mag(c.nfiber+1,j),$
                 err(c.nfiber+1,j),FORMAT='(F9.3,F10.1,F10.1)'
   close,nw    & free_lun,nw
endif
;******save individual spectra for multiple target or circle set up***********
if nstar gt 1 or ncirc gt 1 then begin
   printl,c.log,'Saving ASCII copies of median spectra to '+c.pdir+c.ptemp
;******************loop through valid spectra*********************************
   for i = 0,c.nfiber-1 do if f(i).type eq 'P' or f(i).type eq 'S' or f(i).type eq 'C' then begin
;**********save spectrum and associated error to ASCII file*******************
      file = strtrim(c.starfile,2)+'_M'+strmid(f(i).fib,1,strlen(f(i).fib)-1)
      openw,nw,c.pdir+c.ptemp+file+'.txt',/get_lun
      for j = 0,c.nwl-1 do printf,nw,mag(0,j),mag(i+1,j),err(i+1,j),$
               FORMAT='(F10.4,F10.1,F10.1)'
      close,nw    & free_lun,nw
   endif
endif
;***************treat case where single fiber is observed*********************
if nstar eq 1 then begin
   printl,c.log,'Saving ASCII copy of individual spectra to '+c.pdir+c.ptemp
   file = strtrim(c.starfile,2)+'_M'+strmid(f(c.fiberid-1).fib,1,strlen(f(c.fiberid-1).fib)-1)
   openw,nw,c.pdir+c.ptemp+file+'.txt',/get_lun
   for j = 0,c.nwl-1 do printf,nw,mag(0,j),mag(1,j),err(1,j),$
               FORMAT='(F9.3,F10.1,F10.1)'
   close,nw    & free_lun,nw
endif
end