;*************Procedure view_attn version 1_0********************************
;
;Function   Determine attenuation factor for individual fibers scaled to the average for active fibers
;           The input file must a flat (lamp or twilight sky) recorded in circle set up,
;           analysed with c.fiberatn=0 (to give f.gain=1) to show uncompensated signal levels
;
;Input:   Header data (c,h,f) and text file associated with intermediate spectra (s.1234567.txt)
;
;Report to log:Evaluating fiber attenuation using source file s1234567.txt
;              Standard deviation in attenuations ##.#%
;              Saving plot  of fiber attenuations to file fiber_attn.gif
;              Saving table of fiber attenuations to file fiber_attn.txt
;Report file  :Table of fiber attenuations scaled to the average value for active fibers
;
;Error  FATAL ERROR invalid fiber set up, targets must be in circle setup for attenuations
;       ERROR: fiber gains invalid, fiber attenuation should be unity in source file'
;
;Procedures called:
;printl       - Prints text message to log file
;
;*****************************Procedure***************************************
pro view_attn,c,h,f
printl,c.log,'Evaluating fiber attenuation using source file s'+$
             strtrim(c.starfile,2)+'.txt
;**************check fiber configuration is OK********************************
index = where(f.type eq 'S' and f.line gt 0,nsky)
index = where(f.type eq 'P' and f.line gt 0,nstar)
index = where(f.type eq 'C' and f.line gt 0,ncirc)
if nstar gt 0 or nsky gt 0 or ncirc eq 0 then begin
   printl,c.log,'FATAL ERROR invalid fiber set up, '$
     +'targets must be in circle setup for attenuations'
   return
endif
;*********check no correction made for fiber attenuation in source file*********
if c.fibrattn ne 0 then printl,c.log,'ERROR: fiber gains invalid, '$
     +' fiber attenuation should be unity in source file'
;*******************set up arrays for*******************************************
;**nominal angle of fiber in circle set up (mag) used to check harmonic content*
ang  = dblarr(c.nfiber)
;******************mean signal level read from file s1234567.txt****************
mag  = dblarr(c.nfiber)
;**************flag set to 1 for valid fiber numbers****************************
fib  = intarr(c.nfiber)
;***********maen signal level normalised to average for all valid fibers********
gain = dblarr(c.nfiber)
fib  = intarr(c.nfiber)
;*********************Read star file data***************************************
openr,nr,c.pdir+c.pspec+'p'+strtrim(c.starfile,2)+'.txt',/get_lun
dummy = 'dummy'
readf,nr,dummy
j = 0
while not eof(nr) do begin
      readf,nr,dummy
;*************identify valid fibers in circle set up****************************
      if strpos(dummy,'C')ge 0 then begin
;*********************read fiber number*****************************************
         i = double(strmid(dummy,strpos(dummy,'F')+1,strlen(3)))-1
;*************evaluate nominal angle (assuming 160 fibers in a circle)**********
         ang(j) =  2*!dpi*i/float(c.nfiber)
;********************read mean signal level per fiber***************************
         mag(j) = double(strmid(dummy,strpos(dummy,'C')+2,strlen(10)))
         fib(i) = 1
      endif
      j = j+1
endwhile
close,nr    &    free_lun,nr
ang = ang(0:j-1)
mag = mag(0:j-1)
;***normalise mean signal level per fiber to average value of active fibers****
mag = mag/mean(mag)
index = where(fib gt 0,count)
;**********Interpolate missing fibers in circle for harmonic analysis**********
angint = 2*!dpi*indgen(c.nfiber)/float(c.nfiber)
magint = spline(ang,mag,angint)
;*********************harmonic analysis****************************************
aa  = 2*mean(magint*sin(angint))
bb  = 2*mean(magint*cos(angint))
gain(index) = magint(index)
printl,c.log,'Standard deviation in attenuations '+string(stddev(gain(index))/$
     mean(gain(index))*100,format='(f5.1)')+'%'
;*********************plot fiber attenuation as function of fiber number********
;************title includes note of first component harmonic *******************
fnum = 1 + indgen(c.nfiber)
window,xsize=fix(c.psize*0.6),ysize=fix(c.psize*0.6)  & !P.CHARSIZE=1.2  & !p.multi=0
plot,fnum(index),gain(index),background=c.white,color=c.black,psym=4,thick=1.5,$
ytitle='Relative fiber attenuation',$
yrange=[0,1.3],xtitle='fiber number',title='Fiber attenuation ('+$
string(sqrt(aa^2 + bb^2)*100,format='(f4.1)')+'% 1st harmonic)',$
xstyle=1,xrange=[0,c.nfiber]
WRITE_gif,c.pdir+c.plog+'fiber_attn.gif',TVRD()
printl,c.log,'Saving plot  of fiber attenuations to file fiber_attn.gif'
;*******************Save table of fiber attenuations to text file***************
printl,c.log,'Saving table of fiber attenuations to file fiber_attn.txt'
openw,nw,c.pdir+c.plog+'fiber_attn.txt',/get_lun
printf,nw,'#Fiber   attn'
for i = 0,c.nfiber-1 do printf,nw,i+1,gain(i),format='(I3,3X,F7.4)'
close,nw  &  free_lun,nw
end
