;***********procedure read_file version 1_0**********************
;procedure read_file,dummy,c,h,f,image
;Function  read fits file with pipeline header (page 0 read by default)
;Option    read_file,dummy,c,h,f,image,page=# specifies page number

;Input:    Full file name including path but without .fit extension
;Output:   File header data (c,h,f), array of specified page (image)
;
;Procedures called;None
;
;*****local function used to set consistent path separator(/)*****
function separater,path
for i = 0,10  do if  path_sep() ne '/' and strpos(path,'/') ge 0 then $
   strput,path,'\',strpos(path,'/')
return, path
end
;
;************procedure********************************************
pro read_file,dummy,c,h,f,image,page=PAGE
file = dummy
;*************check file is available to read*********************
openr,nr,file+'.fit',/get_lun,ERROR=err
if err ne 0 then print,'FATAL ERROR: file '+file+'.fit not found'
if err ne 0 then stop
close,nr     & free_lun,nr
;*************read file header (head) and array (image)************
infile = file+'.fit'
print,'reading file   '+infile
image =readfits(infile,head)
;**********read selected page if specified in call to procedure***
if keyword_set(page) then if page gt 0 then $
     image =readfits(infile,EXTEN_NO=page)
;*******set structure for control data structure*******************
;***this is duplicated here so that pipeline files can be read ****
;***even if no local control_data.txt file is avaiable*************
;descriptors of control data are in section 1.1 of developers notes
c = {c,rbname:'x',pdir:'x',fiberid:0,dfiber1:0,dfiber2:0$
      ,skyoset:0,skytype:0,wlmin:0.0D,wlmax:0.0D$

      ,fibrattn:0,profile:0,flattype:0,nscatter:0,wltype:0$

      ,xbin:0,ybin:0,csize:0.0,maskcut:0.0,maskmax:0.0,masklev:0.0$
      ,circlev:0,circsmth:0,circzero:0.0,lwide:0,yavg:0,boxwide:0$
      ,staritn:0,nwl:0L,flatsmth:20$

      ,pdata:'x',pint:'x',pspec:'x',plog:'x',ptemp:'x'$

      ,biaserr:0.0,flaterr:0.0,sighi:0.0,siglo:0.0$
      ,extsigma:0,skymin:0.0,skymax:0.0,msigmax:0.0$

      ,ccdron:0.0D,ccdgain:0.0D,ypixel:0,yzero:0,ymax:0,ccdzero:0L$
      ,noscan:0,oscan1:0,oscan2:0,oscan3:0,oscan4:0,circcutl:0,circcutr:0$
      ,nfiber:0,nfiducl:0,rcircle:0.0D,dfiber3:0,dfiber4:0$
      ,fiberdip:0.0,fiberoff:0.0,pixelsiz:0.0$

      ,arcorder:0,arcwide:0,arcrefc:0,arcrefw:0,arcscale:0,afilecut:0$
      ,atlfile:'x',natl:0,atlscale:0,atlflag:0,atlaline:0$

      ,log:'x',nparam:0,flag1:0,flag2:0,flag3:0,flag4:0$
      ,atl:fltarr(4),atlwl:dblarr(50)$
      ,psize:0,black:0L,red:0L,blue:0L,white:0L$

      ,biasfile:0L,nbias:0,dbias:lonarr(21)$
      ,flatfile:0L,nflat:0,dflat:lonarr(11)$
      ,maskfile:0L,nmask:0,dmask:lonarr(5)$
      ,circfile:0L,ncirc:0,dcirc:lonarr(5)$
      ,arcfile :0L,narc :0,darc :lonarr(2)$
      ,starfile:0L,nstar:0,dstar:lonarr(11)$
      ,osetfile:0L,noset:0,doset:lonarr(11)$
      ,narcline:0,acalwl:dblarr(15)$
      ,apixc:lonarr(15),apixw:lonarr(15),aflag:intarr(15)}

;***Read key control parameters needed for this procedure**********
;*********number of single value control parameters (not arrays)***
c.nparam   = sxpar(head,'NPARAM')
;***************number of fibers and parameters********************
c.nfiber   = sxpar(head,'NFIBER' )
;***set structure for general header parameter (h)*****************
;descriptors of header data (h) are in section 1.2 of developers notes
h = {h,run:0L,obstype:'x',wyffos:'x'$
    ,cenwave:0,disperse:0,linesmm:0,lamp:'x',wyfconf:'x'$
    ,wyfgrat:'x',wyforder:'x',confra:'x',confdec:'x',field:'x'$
    ,ndead:0,nfiber:0,nfiduc:0,ra:'x',dec:'x',equinox:'x'$
    ,jd:0.0D,start:'x',xbin:0,ybin:0,exptime:'x',darktime:0.0}
tag = strupcase(tag_names(h))
;****read values of parameters (h) from fits file header***********
for i = 0,n_elements(tag)-1 do h.(i) = sxpar(head,tag(i))
;***set structure for fiber specific header parameters (f)*********
;descriptors of header data (f) are in section 1.3 of developers notes
fib = {fib,stat:'x',line:0,fib:'x',status:'x',type:'x',name:string(30)$
      ,magn:'x',ra:'x',dec:'x',gain:0.0,sky:0.0,x:0.0D,y:0.0D}
f = replicate ({fib},c.nfiber)
;****read values of fiber parameters (f) from fits file header******
for i = 0,c.nfiber-1 do begin
   if i+1 lt 10 then NAME = 'F00'+strtrim(i+1,2)
   if i+1 ge 10 and i lt 100 then NAME = 'F0'+strtrim(i+1,2)
   if i+1 ge 100 then NAME = 'F'+strtrim(i+1,2)
   f(i).fib   = NAME
   f(i).line  =strtrim(sxpar(head, NAME+'LINE'),2)
   f(i).stat  =strtrim(sxpar(head, NAME+'STAT'),2)
   f(i).type  =strtrim(sxpar(head, NAME+'TYPE'),2)
   f(i).name  =strtrim(sxpar(head, NAME+'NAME'),2)
   f(i).magn  =strtrim(sxpar(head, NAME+'MAGN'),2)
   f(i).ra    =strtrim(sxpar(head, NAME+'RA'  ),2)
   f(i).dec   =strtrim(sxpar(head, NAME+'DEC' ),2)
   f(i).x     =strtrim(sxpar(head, NAME+'X'   ),2)
   f(i).y     =strtrim(sxpar(head, NAME+'Y'   ),2)
   f(i).gain  =strtrim(sxpar(head, NAME+'GAIN'),2)
   f(i).sky   =strtrim(sxpar(head, NAME+'SKY' ),2)
endfor
;*******read (single valued) of control data from fits file header*****
tag = strupcase(tag_names(c))
for i = 0,c.nparam-1 do c.(i) = strtrim(sxpar(head,tag(i)),2)
;******Ensure that all file paths specify a consistent separator*******
  c.pdir  = separater(c.pdir)
  c.pdata = separater(c.pdata)
  c.pint  = separater(c.pint)
  c.plog  = separater(c.plog)
  c.pspec = separater(c.pspec)
  c.ptemp = separater(c.ptemp)
;******read input file data for bias files from fits file header*******
c.nbias    = sxpar(head,'NBIAS')
c.biasfile = sxpar(head,'BIASFILE')
for i = 0,c.nbias-1 do begin
	D_NAME = 'DBIAS'+strtrim(string(i),2)
	c.dbias(i) = sxpar(head,D_NAME)
endfor
;******read input file data for flat files from fits file header*******
c.nflat    = sxpar(head,'NFLAT')
c.flatfile = sxpar(head,'FLATFILE')
for i = 0,c.nflat-1 do begin
	D_NAME = 'DFLAT'+strtrim(string(i),2)
	c.dflat(i) = sxpar(head,D_NAME)
endfor
;******read input file data for dark files from fits file header*******
c.nmask    = sxpar(head,'NMASK')
c.maskfile = sxpar(head,'MASKFILE')
for i = 0,c.nmask-1 do begin
	D_NAME = 'DMASK'+strtrim(string(i),2)
	c.dmask(i) = sxpar(head,D_NAME)
endfor
;******read input file data for circ files from fits file header*******
c.ncirc    = sxpar(head,'NCIRC')
c.circfile = sxpar(head,'CIRCFILE')
for i = 0,c.ncirc-1 do begin
	D_NAME = 'DCIRC'+strtrim(string(i),2)
	c.dcirc(i) = sxpar(head,D_NAME)
endfor
;******read input file data for arc files from fits file header********
c.narc     = sxpar(head,'NARC')
c.arcfile  = sxpar(head,'ARCFILE')
for i = 0,c.narc-1 do begin
	D_NAME = 'DARC'+strtrim(string(i),2)
	c.darc(i) = sxpar(head,D_NAME)
endfor
;******read input file data for star files from fits file header*******
c.nstar    = sxpar(head,'NSTAR')
c.starfile = sxpar(head,'STARFILE')
for i = 0,c.nstar-1 do begin
	D_NAME = 'DSTAR'+strtrim(string(i),2)
	c.dstar(i) = sxpar(head,D_NAME)
endfor
;*read input file data for offset sky  files from fits file header*****
c.noset    = sxpar(head,'NOSET')
c.osetfile = sxpar(head,'OSETFILE')
for i = 0,c.noset-1 do begin
	D_NAME = 'DOSET'+strtrim(string(i),2)
	c.doset(i) = sxpar(head,D_NAME)
endfor
;*********Read arcline data from fits file header**********************
c.narcline = sxpar(head,'NARCLINE')
for i = 0,c.narcline-1 do begin
	A_NAME = 'ACALWL'+strtrim(string(i),2)
	c.acalwl(i) = sxpar(head,A_NAME)
	A_NAME = 'APXLO'+strtrim(string(i),2)
	c.apixc(i)  = sxpar(head,A_NAME)
	A_NAME = 'APXHI'+strtrim(string(i),2)
	c.apixw(i)  = sxpar(head,A_NAME)
	A_NAME = 'AFLAG'+strtrim(string(i),2)
	c.aflag(i)  = sxpar(head,A_NAME)
endfor
end
