;**************Procedure medan_make version 1_0*************************
;*******************Procedure Medan version 1_0**************************
;Procedure	medan_make,mode,c,f,mags,errs,nf,na,mag,err
;Function	Evaluate the median spectra of a  individual spectra for the selected fiber
;           Plot the individual and median spectra to screen .
;
;Input:  Observation type (mode)- 'p' for output sprectra, 'o' for offset sky, 's' for intermediate
;        Observation header data (h,f)
;        Stacked array of spectra on common wavelength base (mags & errs)
;        fiber number (i+1)
;        column number (na) of spectra for which median is found
;Output: array containing median magnitudes (magm) and errors (errm) of
;        spectra with designated column (na) filled
;        Screen shows plot of individual and median spectra for fiber i+1
;
;Procedures called;None
;
;****************************Procedure************************************
pro medan_make,mode,c,f,mags,errs,nf,na,mag,err
;****get number of targets and file list for target or offset sky*********
if mode eq 'o' then nstar = c.noset else nstar=c.nstar
if mode eq 'o' then dstar = c.doset else dstar=c.dstar
;*******************set graphics window************************************
;***one or two columns depending on the number of observations (nstar)*****
if nstar eq 1 then  begin
   !P.MULTI = [0,1,1,0]   & ysiz = fix(0.20*c.psize)  & !p.charsize=0.9
endif
if nstar gt 1 and nstar le 3 then begin
   !P.MULTI = [0,1,nstar+1,0]
   ysiz=fix(0.15*c.psize)*(nstar+1)    &   !p.charsize=1.8
endif
;*******************two columns if 4 or more observations*****************
if nstar gt 3 then begin
   ysiz=fix(0.7*c.psize)   &  !p.charsize=1.4
   !P.MULTI = [0,2,fix(nstar/2)+1,0]
endif
window,xsize=c.psize,ysize=ysiz
;*************set up arrays for median spectra (for one fiber)************
siz = size(mag)
scale = fltarr(nstar)
mag(0,*) = mags(0,*,0)
err(0,*) = errs(0,*,0)
magl  = fltarr(siz(2),nstar)
varl  = fltarr(siz(2),nstar)
;***************loop for individual fibers*******************************
for j = 0,nstar-1 do begin
   fname = strtrim(dstar(j),2)+'_F'+strtrim(nf,2)
;**********set sale factor for spectra equal to mean value****************
   scale(j) = mean(mags(na,*,j))
  if scale(j) gt 0 then SNR  = fix(scale(j)/mean(abs(errs(na,*,j)))) else SNR=0
;***************set title for plot*******************************************
   if nf le c.nfiber then tit = strtrim(dstar(j),2)+'_'+f(nf-1).fib+'  type '$
     +f(nf-1).type+'  SNR '+strtrim(SNR,2)+'    '+$
     c.rbname+'   '+f(nf-1).name else   tit = strtrim(dstar(j),2)+$
     '_Msky' +'  SNR '+strtrim(fix(scale(j)/mean(abs(errs(na,*,j)))),2)+$
     '    '+c.rbname+'     Median sky'
;**************set x axis title  for plot***********************************
   if (mode eq 'p' or mode eq 'o') then xtit='Wavelength (A)' else xtit='Pixel Number'
   if scale(j) gt 70 then ymax = 2*scale(j) else ymax = 400
;***************plot individual spectra and error***************************
   plot,mags(0,*,j),mags(na,*,j),background=c.white,color=c.black,xstyle=1,title=tit,$
         xtitle=xtit , ytitle ='e-/pixel',yrange=[0,ymax]
   oplot,errs(0,*,j),errs(na,*,j),color=c.red
endfor
;*************treat trivial case of single observation *********************
if nstar eq 1 then begin
   mag(na,*) = mags(na,*,0)
   err(na,*) = errs(na,*,0)
   return
endif
;*********get median of a set of observation each normalised to their mean***
for j = 0,nstar-1 do if scale(j) gt 0.0 then begin
   magl(*,j) = mags(na,*,j)/scale(j)
   varl(*,j) = errs(na,*,j)*errs(na,*,j)/scale(j)/scale(j)
endif
mag(na,*) = median(magl,/even,dimension=2)
err(na,*) = median(varl,/even,dimension=2)
;*treat special case of 2 observations as mean corrected for outlying data***
if nstar eq 2 then begin
   max_err = c.msigmax*sqrt(err(na,*))
   index=where((max(magl,dimension=2)-mag(na,*)) gt max_err,count)
   if count gt 0 then mag(na,index) = min(magl(index,*),dimension=2)
   if count gt 0 then err(na,index) = min(varl(index,*),dimension=2)
endif
;*****rescale output spectra to give absolute values in  e-/pixel**************
mag(na,*) = mag(na,*)*mean(scale)*float(nstar)
err(na,*) = sqrt(err(na,*)*float(nstar))*mean(scale)
if mean(mag(na,*)) gt 0 then SNR  = fix(mean(mag(na,*))/mean(err(na,*))) else SNR=0
;***************set title for plot********************************************
if nf le c.nfiber then tit = strtrim(dstar(0),2)+'_M'+$
  strmid(f(nf-1).fib,1,strlen(f(nf-1).fib)-1)+'  Median   SNR'+$
  strtrim(SNR,2)+'    '+c.rbname+'   '+$
  f(nf-1).name else tit = strtrim(dstar(0),2)+'_Msky' +'  SNR '+$
     strtrim(fix(mean(mag(c.nfiber+1,*))/mean(err(c.nfiber+1,*))),2)+$
     '    '+c.rbname+'     Median sky'
if mean(scale*nstar) gt 70 then ymax = 2*mean(scale*nstar) else ymax = 200
;***************plot median spectra and error*********************************
plot,mag(0,*),mag(na,*),background=c.white,color=c.black, title=tit,$
              yrange=[0,ymax],xstyle=1,xtitle=xtit,$
              ytitle = 'e-/pixel'
oplot,err(0,*),err(na,*),color=c.red
end
