;*******************Procedure Medan version 1_0**************************
;Procedure	Medan
;Function	Evaluate median values of extracted spectra, plots and saves results
;Option   	Median,/AUTO  - plots data against pixel No. (no wavelength calibration)
;
;Input	Output sky subtracted spectra files (p1234567.fit) for each observation
;      	Note Starfile (s1234567.fit) used in case of /AUTO mode
;Output	Median spectra output file (q1234567.fit) over common wavelength range
;      	Median file (u1234567.fit) containing spectra versus pixel no. (for auto mode)
;     	Plots showing individual spectra and resulting median spectra for each active fiber
;
;Report to log	RUNNING PROCEDURE:Medan
;           	Medan of files: , p1234567,(etc.) total exposure time #### sec
;           	Median spectra saved to file q1234567
;           	Saving plots to directory c:/####/temp/
;
;Procedures called;
;read_control - Returns control data in structure c
;read_file    - Reads pipeline header (c,h,f) and image of pipeline fits file
;medan_make   - Get median spectra on a common wavelegth base
;write_file   - Writes pipeline header (c,h,f) and data array to fits file
;printl       - Prints text message to log file
;
;****************************Procedure************************************
pro Medan,AUTO=auto
;***************Read control data in structure c**************************
read_control,c
printl,c.log,'RUNNING PROCEDURE:Medan'
;********************read spectra on common wavelength base***************
if not keyword_set(auto) then begin
;********set observation type 'p' for output type spectra of star*********
   mode='p'
;*Read output spectra of first of the starfiles (page 1 mag/ page 2 err)
   read_file,c.pdir+c.pspec+'p'+strtrim(c.starfile,2),cc,h,f,mag,page=0
   read_file,c.pdir+c.pspec+'p'+strtrim(c.starfile,2),cc,h,f,err,page=1
   siz = size(mag)
;****set up arrays to hold stack of output spectra and median spectra*****
   mags  = fltarr(siz(1),siz(2),c.nstar)
   errs  = fltarr(siz(1),siz(2),c.nstar)
   magm  = fltarr(siz(1),siz(2))
   errm  = fltarr(siz(1),siz(2))
;*****copy output spectra of first starfile to stack array****************
   mags(*,*,0) = mag
   errs(*,*,0) = err
;********initialise counter of total exposure time************************
   exptime = float(h.exptime)
;*****copy output spectra of additional starfiles to stack array**********
   if c.nstar gt 1 then for i=1,c.nstar-1 do begin
;****Read output spectra of the starfiles (page 1 mag/ page 2 err)********
      read_file,c.pdir+c.pspec+'p'+strtrim(c.dstar(i),2),cc,hh,ff,mag,page=0
      read_file,c.pdir+c.pspec+'p'+strtrim(c.dstar(i),2),cc,hh,ff,err,page=1
 ;****************copy to stack array*************************************
      mags(*,*,i) = mag
      errs(*,*,i) = err
 ;***********increment total exposure time********************************
      exptime = exptime + float(hh.exptime)
   endfor
;*******set wavelength scale for median spectra***************************
   mags(0,*) = mag(0,*)      &    errs(0,*) = err(0,*)
endif
;****************read raw extracted spectra********************************
if keyword_set(auto) then begin
;****set observation type 's' for intermediate spectra of star************
   mode = 's'
;********initialise counter of total exposure time************************
   exptime = 0
;****set up arrays to hold stack of output spectra and median spectra******
   mags  = fltarr(c.nfiber,c.ymax/c.ybin,c.nstar)
   errs  = fltarr(c.nfiber,c.ymax/c.ybin,c.nstar)
   magm  = fltarr(c.nfiber,c.ymax/c.ybin)
   errm  = fltarr(c.nfiber,c.ymax/c.ybin)
;*****copy intermediate spectra for starfiles to stack array**************
   for k=0,c.nstar-1 do begin
;****Read intermediate spectra of the starfiles (s1234567.fit))***********
      read_file,c.pdir+c.pint+'s'+strtrim(c.dstar(k),2),cc,h,f,spectra
 ;***********increment total exposure time********************************
      exptime = exptime + float(h.exptime)
      for i = 0,c.nfiber-1 do if f(i).type ne 'X' and f(i).line gt 0 then begin
;***index pixel number in column zero of current page of stack array******
         mags(0,*,k) = indgen(c.ymax/c.ybin)
         errs(0,*,k) = indgen(c.ymax/c.ybin)
;****interpolate intermediate spectra over masked sections****************
;********set first and last point of column holding mask data to 1********
         spectra(8*(f(i).line-1)+7,0) = 1
         spectra(8*(f(i).line-1)+7,c.ymax/c.ybin-1) = 1
;Set arrays to hold  pixel No., magnitude and variance of unmasked points
         tempw = dblarr(c.ymax/c.ybin)
         temps = dblarr(c.ymax/c.ybin)
         tempe = dblarr(c.ymax/c.ybin)
;**initialise counter of number of pixels containing unmasked point*******
         j=0
;***fill arrays containing pixel No., mag and val for unmasked point******
         for m = 0,c.ymax/c.ybin-1 do begin
            tempw(j) = mags(0,m,0)
            temps(j) = spectra(8*(f(i).line-1)+5,m)
            tempe(j) = spectra(8*(f(i).line-1)+6,m)
;***increment counter if original spectra contains unmasked point**********
            if spectra(8*(f(i).line-1)+7,m) gt 0.5 then j = j + 1
         endfor
;**truncate arrays of pixel no., mag and var at max No. of unmasked points*
         tempw = tempw(0:j-1)
         temps = temps(0:j-1)
         tempe = tempe(0:j-1)
;*****interpolate data for unmasked points over all pixel values***********
         mags(i+1,*,k)=SPLINE(tempw,temps,mags(0,*,0),/double)
;******taking sqrt of variance to give rms error***************************
         errs(i+1,*,k)=sqrt(SPLINE(tempw,tempe,errs(0,*,0),/double))
      endif
   endfor
;******Resizes stack arrays (mags,errs) in case of single target data******
;**********row 0 wavelength, row 1 fiber spectrum, row 2 blank*************
   if c.fiberid gt 0 and c.fiberid lt c.nfiber then  begin
      mags(1,*,*) = mags(c.fiberid,*,*)
      errs(1,*,*) = errs(c.fiberid,*,*)
      mags = mags(0:2,*,*)
      errs = errs(0:2,*,*)
   endif
;******Resizes median arrays (mags,errs) in case of single target data*****
   magm = mags(*,*,0)
   errm = errs(*,*,0)
endif
;**print list of files analysed and exposure time to screen/log file*******
dummy = 'Medan of files: '
for i =0,c.nstar-1 do dummy  = dummy+', '+mode+strtrim(c.dstar(i),2)
printl,c.log,dummy
printl,c.log,'Total exposure time '+strtrim(fix(exptime),2)+' sec'
;***********Evaluate median for all valid targets***********************
for i = 0,c.nfiber-1 do if f(i).type ne 'X' and f(i).line gt 0 then  begin
;**set column number in mags/errs arrays to be processed to get median***
      if c.fiberid gt 0 and c.fiberid le c.nfiber then na=1 else na=i+1
;***************Calling median_make**************************************
;Input:  Observation type- 'p'  for output spectra, 's' for intermediate
;        Observation header data (h,f)
;        Stacked array of spectra on common wavelegth base (mags & errs)
;        fiber number (i+1)
;        column number (na) of spectra for which median is found
;Output: array containing median magnitudes (magm) and errors (errm) of
;        spectra with designated column (na) filled
;        Screen shows plot of individual and median spectra for fiber i+1
   medan_make,mode,c,f,mags,errs,i+1,na,magm,errm
;****Save plot of individual and median spectra for fiber number ###****
;****plot saved to file 1234567M###.gif in directory /temp**************
   fib=f(i).fib
   strput,fib,'M',strpos(fib,'F')
   WRITE_gif,c.pdir+c.ptemp+strtrim(c.dstar(0),2)+'_'+fib+'.gif',TVRD()
endif
;***Evaluate median for individual median skys (one per observation)****
if not keyword_set(auto) then begin
;************check that a median sky spectra will have been created*****
   index = where(strcmp(f.type,'S'),nsky)
   if nsky gt 1  then  begin
;***************Calling median_make*************************************
;************see notes above********************************************
      medan_make,mode,c,f,mags,errs,c.nfiber+1,c.nfiber+1,magm,errm
;****plot saved to file 1234567Msky.gif in directory /temp**************
      WRITE_gif,c.pdir+c.ptemp+strtrim(c.starfile,2)+'_Msky.gif',TVRD()
   endif
endif
;***************Save  output spectra to file****************************
h.exptime = exptime
if keyword_set(auto) then mode='u' else mode='q'
write_file,c.pdir+c.pspec+mode+strtrim(c.starfile,2),c,h,f,magm,page=0
write_file,c.pdir+c.pspec+mode+strtrim(c.starfile,2),c,h,f,errm,page=1
printl,c.log,'Median spectra saved to file'+mode+strtrim(c.dstar(0),2)
printl,c.log,'Saving plots to directory '+c.pdir+c.ptemp
!p.multi=0
end

