;******************Procedure Flat version 1_0************************
;Procedure	Flat
;Function	Check the input file type, binning and fiber allocation are correct
;        	Create a median flat image
;
;Input	   Raw data flat files - series of raw data files (r1234567.fit)
;Output 	   Flatfile (f1234567.fit) containing median flat image
;
;Reports to log	RUNNING PROCEDURE:Flat
; 	               New Flat file created:f1234567 median of # file
; 	               Saving copy of Flat.gif
;Report files	   Copy of median flat image (flat.gif)

;Error 	FATAL ERROR: incorrect file type, file type is xxx
;message WARNING: high noise in flat files, ### adu
;     	ERROR: Saturation of flat image (>99% full scale)
;     	WARNING: High flat image, ## of full scale
;      	WARNING: Low flat image, ## of full scale
;
;Procedures called;
;read_control - Returns control data in structure c
;read_data    - Reads pipeline header (c,h,f) and binary image of raw data file
;file_debias  - Reads pipeline header (c,h,f) and data array
;write_file   - Writes pipeline header (c,h,f) and data array to fits file
;printl       - Prints text message to log file
;
;*****************Procedure**************************************
pro Flat
;***************Read control data in structure c*****************
read_control,c
printl,c.log,'RUNNING PROCEDURE:Flat
;**************clear open windows********************************
while (!d.window ge 0) do wdelete,!d.window
;***read header and debiased image of first flat file in list****
read_data,c.flatfile,c,h,f,image
;***************Check file type**********************************
if (not strcmp(strtrim(h.obstype,2),'FLAT')) and $
  (not strcmp(strtrim(h.obstype,2),'TARGET'))then begin
   printl,c.log,'FATAL ERROR: incorrect file type, file type is '+h.obstype
   stop
endif
;***************creat median bias file***************************
;*****define arrays to hold stack of flat images and output******
siz = size(image)
inarr = fltarr(siz(1),siz(2),c.nflat)
outarr= fltarr(siz(1),siz(2))
scale = dblarr(c.nflat)
;*************load flat images into stack array******************
for i = 0,c.nflat-1 do begin
;*********read header and debiased flat image********************
   file_debias,c.dflat(i),c,h,f,image
;*******scale image to its mean value before taking median ******
   scale(i) = 1.0/mean(image)
   inarr(*,*,i) = image*scale(i)
endfor
;****define outarr as median of stack array and rescale**********
if c.nflat gt 1 then outarr = median(inarr,DIMENSION=3)/mean(scale) $
                                     else outarr = image
;*******save median image to flat file (f1234567.fit)*********
write_file,c.pdir+c.pint+'f'+strtrim(c.flatfile,2),c,h,f,outarr
printl,c.log,'New flat file created:f'+strtrim(c.flatfile,2)$
     +' median of '+strtrim(c.nflat,2)+' files'
;**********check noise level of flat images*******************
;****calculate rms level of flat signal relative to median****
if c.nflat  gt 1 then begin
   for i = 0,c.nflat-1 do  inarr(*,*,i) = inarr(*,*,i)/scale(i)
   delerr =  string(sqrt(mean((inarr-outarr)*(inarr-outarr))),FORMAT='(f6.1)')
   flaterr = c.biaserr*c.ccdron*c.ccdgain + c.flaterr*sqrt(mean(outarr))
   if float(delerr) gt  flaterr then printl,c.log,$
       'WARNING: high noise in flat files, '+strtrim(delerr,2)+' adu'
endif
;**************check flat signal level************************
;**measure peak level in (ystep) cuts through the flat image**
;**cuts averaged over several pixels in wavelength direction**
ystep = fix(c.ymax/c.ybin/fix(c.circlev+1))
pklev = fltarr(c.circlev)
for i = 0,c.circlev - 1 do pklev(i) = max(median(dimension=2,$
         image(*,ystep*(i+1)-c.yavg/c.ybin:ystep*(i+1)+c.yavg/c.ybin)))
;******express peak value as a fraction of full scale*********
pklev = pklev/(2.0*float(c.ccdzero))
;**Error if normalised peak is under/over specified value*****
if max(pklev) ge 0.99 then printl,c.log,$
  'ERROR: saturation of flat image (>99% full scale)'
if max(pklev) ge c.sighi then printl,c.log,'WARNING: high flat image, '$
+string(max(pklev),format='(f5.2)')+' of full scale'
if min(pklev) le c.siglo then printl,c.log,'WARNING: low flat image, '$
+string(min(pklev),format='(f5.2)')+' of full scale'
;**********Display TV image of flat file image******************
;**********get constant to scale image to screen***************
tvsize = max([1+ siz(1)/fix(0.7*c.psize),1+ siz(2)/fix(0.7*c.psize)])
window,0,xsize=siz(1)/tvsize,ysize=siz(2)/tvsize
;******display TV image on screen******************************
tv,rebin(outarr(0:tvsize*(siz(1)/tvsize)-1,0:tvsize*(siz(2)/tvsize)-1)$
   /mean(outarr),siz(1)/tvsize,siz(2)/tvsize)*100
;******save copy of screen image to log file Flat.gif***********
printl,c.log,'Saving copy of Flat.gif'
WRITE_gif,c.pdir+c.plog+'Flat.gif',TVRD()
end
