;*********Procedure file_debias version 1_0*********************
;Procedure	file_debias,nfile,c,h,f,image
;Function   read raw data file, dbias the image using intermediate
;           bias image b1234567.fit and compensate for dc offset
;
;Input:     control data (c) and file number (nfile)
;Output:    file header data (,c,h,f) and debiased image (image)
;
;;Error 	FATAL ERROR: readout binning does not match control data
;message ERROR: central wavelength not compatible with target file r1234567
; 	      FATAL ERROR: allocation of active fibers incompatible with target file r1234567
;
;Procedures called;
;read_data    - Reads pipeline header (c,h,f) and binary image of raw data file
;read_file    - Reads pipeline header (c,h,f) and image of pipeline fits file
;printl       - Prints text message to log file
;
;*********************Procedure***********************************
pro file_debias,nfile,c,h,f,image
;********read intermediate bias file image (biasim)***************
bfile = c.pdir+c.pint+'b'+strtrim(c.biasfile,2)
read_file,bfile,cb,hb,fb,biasim
;***********set up image array to hold dc bias********************
siz = size(biasim)
dcbias= fltarr(siz(1),siz(2))
;***read header and image of data file r1234567.fit***************
read_data,nfile,c,h,f,inarr
;****convert image to floating point and subtract bias image******
image = (float(inarr) + c.ccdzero -biasim)
;*******check x and y binning is compatible with control data*****
if (h.xbin ne c.xbin) or  (h.ybin ne c.ybin) then $
printl,c.log,'FATAL ERROR: readout binning does not match control data'
if (h.xbin ne c.xbin) or  (h.ybin ne c.ybin) then stop
;**set counter to identify input file type, 1 is true 0 is false**
index = where(c.dflat eq nfile,iflat)
index = where(c.darc  eq nfile,iarc)
index = where(c.dstar eq nfile,istar)
index = where(c.doset eq nfile,ioset)
index = where(c.dmask eq nfile,imask)
;*****check central wavelength compatible with target image*******
;*****for file types flat,arc,star,offset sky*********************
if  iflat + iarc + istar + ioset gt 0 then begin
   read_data,c.starfile,sc,sh,sf
   if (h.cenwave ne sh.cenwave) then    printl,c.log,'ERROR: central '$
    +'wavelength not compatible with target file r'+strtrim(c.starfile,2)
endif
;**check fibers flagged as active  compatible with target image***
err_type = 0
;***********for file types star and offset sky********************
if istar+ioset gt 0 then for i=0,c.nfiber-1 do $
     if (strcmp(f(i).type,'X')-strcmp(sf(i).type,'X')) ne 0 then err_type=1
;***********for file types flat and arc***************************
if iflat+iarc  gt 0 then for i=0, c.nfiber-1 do $
     if strcmp(f(i).type,'X') then if not strcmp(sf(i).type,'X') then err_type=1
;**********report error if incompatible***************************
if err_type gt 0 then printl,c.log,'FATAL ERROR: allocation of active fibers'$
     +' incompatible with target file r'+strtrim(c.starfile,2)
   if err_type gt 0 then stop
;**********Correct for dc bias using overscan regions*************
;*****get median dc offset using overscan regions of LHS of CCD***
dcbias(0:(siz(1)/2-1),*)=$
   (median(image(c.oscan1/c.xbin-c.noscan/c.xbin:c.oscan1/c.xbin-1,*))$
  + median(image(c.oscan2/c.xbin:c.oscan2/c.xbin+c.noscan/c.xbin-1,*)))/2.0
;*****get median dc offset using overscan regions of RHS of CCD***
dcbias((siz(1)/2):(siz(1)-1),*)=$
   (median(image(c.oscan3/c.xbin-c.noscan/c.xbin:c.oscan3/c.xbin-1,*))$
   +median(image(c.oscan4/c.xbin:c.oscan4/c.xbin+c.noscan/c.xbin-1,*)))/2.0
;*****correct debiased image for any dc offset found**************
image = image - dcbias
end
