;*********Procedure extr_make version 1_0*************************
;Procedure  extr_make,c,h,image,var,mask,prob,type,nit,lspec,vspec,dspec
;
;Function   optimally extract line spectrum from the measured trace on
;           the CCD image See algorithm in  Fig15 of user manual
;
;Input:     extract file header data (c,f) and image (image) and variance (var)
;           mask (mask),profile (prob) target types (type) and No. iterations (nit)
;
;Procedures called;
;printl       - Prints text message to log file
;
;***************Procedure**********************************************
pro extr_make,c,h,image,var,mask,prob,type,nit,lspec,vspec,dspec
;***************************Set up*************************************
siz = size(image)
nline = siz(1)/(c.lwide/c.xbin+4)
;********set up arrays for extracted spectrum, variance****************
lspec= fltarr(nline,siz(2))
vspec= fltarr(nline,siz(2))
;****set up working array holding denominator of extraction formula****
dspec= fltarr(nline,siz(2))
;***set up array holding predicted line profile************************
pred = fltarr(siz(2))
;**set up array of pixels to be masked - initial value = input mask*****
msig = mask
lcount = 0
diff  = dblarr(c.lwide/c.xbin+1,siz(2))
;***************extract spectrum***************************************
for k = 0,nit do begin
   lcount = 0
   for i = 0,nline-1 do if not strcmp(type(i),'X') then begin
;**********Define terms required for optimal extraction****************
     n0 = i*(c.lwide/c.xbin+4)+2
     n1 = (i+1)*(c.lwide/c.xbin+4)-2
     lspec(i,*) = total(msig(n0:n1,*)*prob(n0:n1,*)*image(n0:n1,*)/var(n0:n1,*),1)
     vspec(i,*) = total(msig(n0:n1,*)*prob(n0:n1,*),1)
     dspec(i,*) = total(msig(n0:n1,*)*prob(n0:n1,*)*prob(n0:n1,*)/var(n0:n1,*),1)
;*Block pixels of output spectra where more than 50% of input is masked*
     index = where(total(msig(n0:n1,*)*prob(n0:n1,*),1) lt 0.5,count)
     if count gt 0 then dspec(i,index) = 1.0e15
;*increment total number of blocked points in all extracted spectra ****
     lcount = lcount + count
;*******evaluate magnitude and variance arrays of extracted spectra*****
     lspec(i,*) = lspec(i,*)/dspec(i,*)
     vspec(i,*) = vspec(i,*)/dspec(i,*)
 ;**Identify pixel with signal >N sigma beyond from predicted profile**
     diff = abs(msig(n0:n1,*)*(image(n0:n1,*) - prob(n0:n1,*)*lspec(i,*)))
     sdev = stddev(diff)
 ;*if difference greater that c.extsigma for pixel then set mask (msig)
     index = where(diff gt c.extsigma*sdev,count)
     if count gt 0 then msig(n0:n1,index) = 0.0
  endif
;***print image type and number of masked points to log file***********
  printl,c.log,strtrim(h.obstype,2)+'   Iteration '+strtrim(k,2)+$
       '   masked points = ' +strtrim(lcount,2)
endfor
end
