;**************Procedure ext_file version 1_0*********************
;Procedure   extr_file,nfile,nit,h,f,spectra
;Function	Optimal extraction of spectra for a targets in a star file
;
;Input	     stafile number (1234567), number of repeat iterations of optimal extraction process
;Output	  header data (h,f) and intermediate spectra array for starfiles (s1234567.fit)
;
;Report to log	Extracting file r1234567 (Repeated for each target)
;           	FLAT    Iteration 0   masked points = ###  (etc.)
;           	TARGET   Iteration 0   masked points = ### (etc.)

;Error    ERROR: Saturation of extracted image (>99% full scale)
;message WARNING: Flat signal zero over part of spectra - a total of ## bad pixels masked
;                 WARNING: high extracted image, ## of full scale
;
;Procedures called;
;read_control - Returns control data in structure c
;file_debias  - Reads pipeline header (c,h,f) and debiased image from data file
;file_offset  - offset image to centre of each line  at a uniform x value
;printl       - Prints text message to log file
;
;***************************Procedure*********************************
pro extr_file,nfile,nit,h,f,spectra
;***************Read control data in structure c**********************
read_control,c
printl,c.log,'Extracting file r'+strtrim(nfile,2)
;****************Get input and associated files***********************
;read circfile header (hc,fc) to get line No. and attenuation for each each fiber
;read  image (offset) which gives offset of lines on CCD image
read_file,c.pdir+c.pint+'c'+strtrim(c.circfile,2),cc,hc,fc,offset
siz = size(offset)
;************get number of lines (traces) on CCD image****************
nline = siz(1)/(c.lwide/c.xbin+4)
;**********read the starfile header (h,f) and debiased image**********
file_debias,nfile,c,h,f,dummy
;*offset image (star) with centres of each line  at a constant x value
file_offset,c,h,dummy,offset,star
;******read the intermediate mask image (if required)*****************
if c.nmask gt 0 then begin
    read_file,c.pdir+c.pint+'m'+strtrim(c.maskfile,2),cm,hm,fm,dummy
;*offset image (mask) with centres of each line  at a constant x value
    file_offset,c,h,dummy,offset,mask
endif else mask = fix(star*0+1)
;**********read the median  flat file image***************************
read_file,c.pdir+c.pint+'f'+strtrim(c.flatfile,2),cf,hf,ff,dummy
;*offset image (flat) with centres of each line  at a constant x value
file_offset,c,hf,dummy,offset,flat
;**************check star signal level******************************
;*****measure peak level in (ystep) cuts through the flat image*****
;*****cuts averaged over several pixels in wavelength direction*****
ystep = fix(c.ymax/c.ybin/fix(c.circlev+1))
pklev = fltarr(c.circlev)
for i = 0,c.circlev - 1 do pklev(i) = max(median(dimension=2,$
         star(*,ystep*(i+1)-c.yavg/c.ybin:ystep*(i+1)+c.yavg/c.ybin)))
;******express peak value as a fraction of full scale***************
pklev = pklev/(2.0*float(c.ccdzero))
;**Error if normalised peak is saturated or  specified value*********
if max(pklev) ge 0.99 then printl,c.log,$
  'ERROR: saturation of extracted image (>99% full scale)'
if max(pklev) ge c.sighi then printl,c.log,'WARNING: high extracted image '$
+string(max(pklev),format='(f5.2)')+' of full scale'
;Copy circfile values of line No. and attenuation to starfile header
f.line = fc.line
f.gain = fc.gain
;*Scale starfile and flat by CCD gain to give output in e- per pixel
star = star/c.ccdgain
flat = flat/c.ccdgain
;***********set up variance arrays for star and flat****************
vars = abs(star) + c.ccdron*c.ccdron
varf = abs(flat) + c.ccdron*c.ccdron
index = where(mask lt 0.1,count)
if count gt 0 then begin
   vars(index) = c.ccdron*c.ccdron
   varf(index) = c.ccdron*c.ccdron
endif
;***********Set up extraction profile*******************************
;get width of strip encompassing a line (trace) on the CCD
wide = c.lwide/c.xbin+4
;*********get profile in case of a top hat profile (non standard)***
if c.profile eq 0 then begin
   prob = flat*0.0
   for i=0,nline-1 do prob(i*wide+c.lwide/c.xbin/2+2-c.boxwide/c.xbin/2$
                  :i*wide+c.lwide/c.xbin/2+2+c.boxwide/c.xbin/2,*)=1.0
   endif
;*********get profile for optimal extraction************************
siz = size(dummy)
if c.profile eq 1 then begin
;*********smooth flat profile in the wavelength direction************
   for j=0,siz(1)-1 do dummy(j,*) = smooth(dummy(j,*),c.yavg/c.ybin)
;*offset profile (prob) with centres of each line  at a constant x value
   file_offset,c,h,dummy,offset,prob
endif
;*******set target type as a function of line (trace) number********
type = strarr(nline)
for i = 0,c.nfiber-1 do if fc(i).line gt 0 then $
   type(fc(i).line-1)=f(i).type
;************Subtract scattered light (iff required)****************
;The offset image contains the median signal level between traces***
;These levels are liniarly interpolated over the width of the trace*
;to estimate the background level of scattered light for an image***
if c.nscatter eq 1 then begin
;define array of scattered light for star, flat and probability image
   scats = fltarr(wide*nline,c.ymax/c.ybin)
   scatf = fltarr(wide*nline,c.ymax/c.ybin)
   scatp = fltarr(wide*nline,c.ymax/c.ybin)
   for i = 0,nline-1 do begin
      for j = 0,wide-4 do begin
         scats(i*wide+j+2,*)=star((i*wide+1),*)+$
           (star(((i+1)*wide-1),*)-star((i*wide+1),*))*float(j)/(wide-4)
         scatf(i*wide+j+2,*)=flat((i*wide+1),*)+$
           (flat(((i+1)*wide-1),*)-flat((i*wide+1),*))*float(j)/(wide-4)
         scatp(i*wide+j+2,*)=prob((i*wide+1),*)+$
           (prob(((i+1)*wide-1),*)-prob((i*wide+1),*))*float(j)/(wide-4)
      endfor
   endfor
;subtract scattered light array from star, flat and probability image
   star = star - scats
   flat = flat - scatf
   prob = prob - scatp
endif
;**********set miminun value of these arrays to zero******************
index = where(star lt 0,count)
if count gt 0 then star(index) = 0.0
index = where(flat lt 0,count)
if count gt 0 then flat(index) = 0.0
index = where(prob lt 0,count)
if count gt 0 then prob(index) = 0.0
;************************normalise probability profile*****************
ptotal = fltarr(c.ymax/c.ybin)
;***set up probabilty mask where pmask=1 if probability profile is valid*
;*to extract the spectra at a given y-pixel position of a given spectra
pmask  = intarr(nline,c.ymax/c.ybin)+1
;**Check and normalise probability profile at all valid line positions**
for i = 0,nline-1 do if not strcmp(type(i),'X') then begin
;******sum probability profile across width of trace*******************
   ptotal(*) = total(prob(i*wide+2:(i+1)*wide-2,*),1)
   index  = where(ptotal eq 0,nzero)
;**for y-pixel positions where sum is zero set probability mask to zero**
   if nzero gt 0 then ptotal(index) = 1.0
   if nzero gt 0 then pmask(i,index) = 0
   for j = 2,wide-2 do prob(i*wide+j,*) = prob(i*wide+j,*)/ptotal(*)
endif
;Print log message if any pixels are masked for bad probabilty profile
index  = where(pmask eq 0,nzero)
if nzero then printl,c.log,'WARNING: Flat signal zero over part of spectra -'+$
         ' a total of '+strtrim(nzero,2)+' bad pixels masked'
;**********************Extract spectra ********************************
;***************Calling extr_make**************************************
;Input:  Flat file header data (c,hf) flat image (flat) and variance (varf)
;        mask (mask),profile (prob) target types (type) and No. iterations (nit)
;Output: line (extracted) spectra of flat (lspecf) and variance (vspecf)
extr_make,c,hf,flat,varf,mask,prob,type,nit,lspecf,vspecf
;***************Calling extr_make**************************************
;Input:  Flat file header data (c,h) flat image (star) and variance (vars)
;        mask (mask),profile (prob) target types (type) and No. iterations (nit)
;Output: line (extracted) spectra of star (lspecs) and variance (vspecs)
extr_make,c,h,star,vars,mask,prob,type,nit,lspecs,vspecs
;Load extracted spectra of flat and star into intermediate spectra array
;each line (trace) is represented by 8 columns (0 to 7 etc) of the array
;***column 0 is zero (later it will hold  wavelength vs pixel No.)*****
spectra = fltarr(8*nline,c.ymax/c.ybin)
for i = 0,nline-1 do if not strcmp(type(i),'X') then begin
;***columns 1 and 2 hold the magnitude an variance of the star spectra
   spectra(i*8+1,*) = lspecs(i,*)
   spectra(i*8+2,*) = vspecs(i,*)
;***columns 3 and 4 hold the magnitude an variance of the flat spectra
   spectra(i*8+3,*) = lspecf(i,*)
   spectra(i*8+4,*) = vspecf(i,*)
;*************get mean magnitude of (unmasked) flat spectra**************
   index  = where(lspecf(i,*) gt 0.1,count)
   if count gt 0 then meanf = total(lspecf(i,index))/float(count) $
      else meanf=mean(lspecf)
;*********valid pixel positions of star spectrum*************************
;**********these are unmasked points with a good extraction profile******
   index = where((lspecf(i,*) gt 0.01) and (lspecs(i,*) gt 0.01) $
                 and (pmask(i,*) gt 0),count)
;*columns 5 and 6 hold the magnitude an variance of the normalise spectra
;*****which is (star spectrum/flat spectrum) x mean flat signal***********
   if count gt 0 then begin
      spectra(i*8+5,index) = lspecs(i,index)*meanf/lspecf(i,index)
      spectra(i*8+6,index) = vspecs(i,index)*(meanf/lspecf(i,index))*$
                                             (meanf/lspecf(i,index))
      spectra(i*8+7,index) = pmask(i,index)
   endif else begin
      spectra(i*8+5,*) = lspecs(i,*)* mflat/lspecf(i,*)
      spectra(i*8+6,*) = vspecs(i,*)*mflat*mflat/lspecf(i,*)/lspecf(i,*)                                *(mflat/lspecf(i,*))
      spectra(i*8+7,*) = pmask(i,*)
   endelse
endif
end