;*********Procedure Bias version 1_0**************************
;Procedure Bias
;Function  Check the input file type is correct
; 	        Create a median bias file
;
;Input	  Raw data bias files - series of raw data files (r1234567.fit)
;Output 	  Biasfile (b1234567.fit) containing the median bias image
;
;Reports to log	'RUNNING PROCEDURE:Bias'
; 	               New Bias file created:b1234567
; 	               Saving copy of Bias.gif
;
;Report files	   Copy of median bias image (bias.gif)
;
;Error 	FATAL ERROR: readout binning does not match control data
;message FATAL ERROR: incorrect file type, file type is xxx
; 	      WARNING: high noise in bias images ### adu
;
;Procedures called;
;read_control - Returns control data in structure c
;read_data    - Reads pipeline header (c,h,f) and binary image of raw data file
;write_file   - Writes pipeline header (c,h,f) and data array to fits file
;printl       - Prints text message to log file
;
;*****************Procedure**************************************
pro Bias
;***************Read control data in structure c*****************
read_control,c
printl,c.log,'RUNNING PROCEDURE:Bias'
;***read header and  image of first bias file in list************
read_data,c.biasfile,c,h,f,image
;*********Check file binning and observation type ***************
if (h.xbin ne c.xbin) or  (h.ybin ne c.ybin) then $
printl,c.log,'FATAL ERROR: readout binning does not match control data'
if (h.xbin ne c.xbin) or  (h.ybin ne c.ybin) then stop
if not strcmp(strtrim(h.obstype,2),'BIAS')  then $
printl,c.log,'FATAL ERROR: incorrect file type, file type is '+h.obstype
if not strcmp(strtrim(h.obstype,2),'BIAS') then stop
;***************creat median bias file***************************
;**************define array to hold stack of bias images*********
siz = size(image)
inarr = fltarr(siz(1),siz(2),c.nbias)
;*************load bias images into stack array******************
for i = 0,c.nbias-1 do  begin
   read_data,c.dbias(i),c,h,f,image
   inarr(*,*,i) = float(image + c.ccdzero)
endfor
;***********define outarr as median of stack array***************
if c.nbias gt 1 then outarr = median(inarr,dimension=3) $
    else outarr = inarr
;**********check noise level of bias images**********************
;****calculate rms level of bias signal relative to median*******
if c.nbias gt 1 then delerr = sqrt(mean((inarr-outarr)*(inarr-outarr))) $
    else delerr=0.0
;**compare value to alarm level c.biaserr*c.ccdron*c.ccdgain*****
if float(delerr) gt c.biaserr*c.ccdron*c.ccdgain then printl,c.log,$
'WARNING: high noise in Bias files: '+string(delerr,FORMAT='(f6.1)')+' adu'
;*******save median image to bias file (b1234567.fit)************
write_file,c.pdir+c.pint+'b'+strtrim(c.biasfile,2),c,h,f,outarr
printl,c.log,'New Bias file created:b'+strtrim(c.biasfile,2)$
              +' median of '+strtrim(c.nbias,2)+' files'
;**********Display TV image of bias file image*********************
;**********get constant to scale image to screen******************
tvsize = max([1+ siz(1)/fix(0.7*c.psize),1+ siz(2)/fix(0.7*c.psize)])
;******display TV image on screen*********************************
window,0,xsize=siz(1)/tvsize,ysize=siz(2)/tvsize
tv,rebin(outarr(0:tvsize*(siz(1)/tvsize)-1,0:tvsize*(siz(2)/tvsize)-1)$
      /mean(outarr),siz(1)/tvsize,siz(2)/tvsize)*100
;******save copy of screen image to log file Bias.gif*************
printl,c.log,'Saving copy of Bias.gif'
WRITE_gif,c.pdir+c.plog+'Bias.gif',TVRD()
end

