;*************Procedure arc_offset version 1_0********************
;procedure arc_offset,c,h,f,spectra,yoff
;Function  plots an overlay of arc spectra using y-offsets calculated from header data
;          Estimates the  y-offsets form the position of the peak in a selected spectral line
;          plots the estimated y offset as a function of fiber number
;
;Option    procedure arc_offset,c,h,f,spectra,yoff,/window works as above
;          but defines a new plot window for graphical output (used with Atlas procedure)
;
;Input:  arcfile header and intermediate spectra (c,h,f,spectra)
;Output: yoff - relative offset of individual arc spectra in pixels found
;               by comparing position of a selected line in the spectra
;
;Procedures called;
;read_control - Returns control data in structure c
;printl       - Prints text message to log file
;
;**************************Procedure *********************************
pro arc_offset,c,h,f,spectra,yoff,window=WINDOW
;***************Read control data in structure c**********************
read_control,c
;*****************Set plot window (only for option /window)***********
if keyword_set(window) then begin
   window,xsize=fix(c.psize*0.7),ysize=fix(c.psize*0.4)
   !P.MULTI = [0,1,2,2,0]  & !P.CHARSIZE=1
   color = 0
endif else color=c.black
;*********set y axis range for plots***********************************
yscale = 2*float(c.ccdzero)*(c.lwide-4)/4.0
if c.arcscale gt 1 then yscale = yscale/float(c.arcscale)
;***********rough estimate of estimate y-offsets using header data*****
yoffo = fltarr(c.nfiber)
j = 0
;*****estimate maximum offset across CCD from header dispersion********
fiberdip = fix(c.fiberdip/float(c.ybin*h.disperse))
for i = 0,c.nfiber-1 do begin
;******get nominal fiber position counter across CCD image**************
   if  i mod (c.nfiber/c.nfiducl) gt 0 then j = j + 1
;*********translate this to a nominal distance from the centerline******
   yoffo(i) = (2*j - c.nfiber+c.nfiducl)/float(c.nfiber-c.nfiducl)
;*******calculate the yoffset as a function of this distance squared****
   yoffo(i) = yoffo(i) * yoffo(i) * fiberdip
;*******add a term to take account or the 1/2/3 stagger of fibers*******
   yoffo(i) = fix(yoffo(i) + (j mod 3) * c.fiberoff/c.ybin)
endfor
;********set offset of inactive fibers to negative value***************
ymaxo = max(yoffo)
yoffo(where(f.type eq 'X')) = -ymaxo/5
;********Fill array holding offset spectra for all active fibers*******
specoffo = fltarr(c.nfiber,c.ymax/c.ybin+ymaxo)
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then $
   specoffo(i,ymaxo-yoffo(i):ymaxo-yoffo(i)+c.ymax/c.ybin-1)=$
            spectra(8*(f(i).line-1)+5,*)
;**************identify fiber with lowest y offset*********************
dummy = min(yoffo(where(f.line gt 0 and f.type ne 'X')),fiblo)
;****if extracting single fiber replace this with single fiber no.-1***
if c.fiberid gt 0 and c.fiberid le c.nfiber then fiblo = c.fiberid-1
ymaxo = max(yoffo)
;*************plot composite of offset arc spectra**********************
tit = 'Overlay of arc spectra with geometric offset, '+strtrim(h.lamp,2)+' lamp'
;*****plot offset so that arc spectra near centre of CCD start at zero**
pixelo   = indgen(c.ymax/c.ybin+ymaxo)-ymaxo
plot,pixelo,specoffo(fiblo-1,*),background=c.white,ytitle='e-/pixel',$
       xstyle=1,title=tit, color=c.black,yrange=[0,yscale],xticklen=0.1,$
       ystyle=1,xtitle ='pixel number'
for i = 0,c.nfiber-1 do oplot,pixelo,specoffo(i,*),color=c.blue
oplot,pixelo,specoffo(fiblo-1,*),color=c.black
;***add markers identifying arcline used for offset calculation to plot*
mark = fltarr(c.ymax/c.ybin+fiberdip+c.fiberoff/c.ybin)-c.ccdzero
if c.arcrefc-c.arcrefw  gt 0 and c.arcrefc+c.arcrefw  lt $
   c.ymax/c.ybin+fiberdip+c.fiberoff/c.ybin-2 gt 0 then begin
   mark(c.arcrefc-c.arcrefw-1:c.arcrefc-c.arcrefw+1) = yscale/2
   mark(c.arcrefc+c.arcrefw-1:c.arcrefc+c.arcrefw+1) = yscale/2
   oplot,indgen(c.ymax/c.ybin+fiberdip+c.fiberoff/c.ybin),mark,color=c.red
endif
;********Calculate y offset per fiber using reference peak****************
yoff  = fltarr(c.nfiber)
;*******check line markers are in range and not in single fiber mode******
if (c.arcrefc - c.arcrefw) gt 0 and (c.arcrefc + c.arcrefw) lt c.ymax/c.ybin-ymaxo-1 $
   and (c.fiberid eq 0 or c.fiberid gt c.nfiber) then begin
;*********find pixel number of peak in spectra within specified range*****
   for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then begin
      spec = spectra(8*f(i).line-8+5,yoffo(i):c.ymax/c.ybin+yoffo(i)-ymaxo-1)
       maxx = max(spec(c.arcrefc-c.arcrefw:c.arcrefc+c.arcrefw),max_sub)
      yoff(i) = max_sub
   endif
;**********make sure that all y offset of all active fibers is > 0*******
   yoff = fix(yoff - mean(yoff(where(f.line eq 0 or f.type ne 'X'))) +yoffo)
endif else yoff = yoffo
yoff(where(yoff lt 0))=0
;*********set negative value for inactive fibers*************************
yoff(where(f.line eq 0 or f.type eq 'X')) = -ymaxo/5
;*******plot calculated values of y-offset against fiber number**********
plot, yoff,background=c.white,color=c.black,psym=4,ytitle='Pixels',$
  yrange=[min(yoffo),1.3*max(yoffo)],symsize=0.5,$
  title = 'Offset of spectra used in wavelength calibration'$
  ,xtitle ='Fiber number',xrange=[-1,c.nfiber],xstyle=1
;********Repeat initial plot (for option /window)*************************
;********this is done in order to leave the plot of overlay arc spectra***
;*****as the active plot window which can then be accessed by the ********
;*graphical user interface to select a new line for the offset calculation
if keyword_set(window) then begin
   tit = 'Overlay of arc spectra with geometric offset, '+strtrim(h.lamp,2)+' lamp'
   plot,pixelo,specoffo(fiblo,*),background=c.white,ytitle='e-/pixel',$
       xstyle=1,title=tit,color=c.black,yrange=[0,yscale],ystyle=1,$
       xtitle ='pixel number'
   for i = 0,c.nfiber-1 do oplot,pixelo,specoffo(i,*),color=c.blue
   oplot,pixelo,specoffo(fiblo-1,*),color=c.black
   oplot,indgen(c.ymax/c.ybin+fiberdip+c.fiberoff/c.ybin),mark,color=c.red,thick=1.5
endif
end



