;*************Procedure arc_atlas version 1_0************************
;Input:   arcfile header (c,h,f) and intermediate spectra (spectra)
;         yoff - relative offset of individual arc spectra in pixels (yoff)

;Function:Plot overlay of arc spectra per fiber offset by values of yoff
;         with markers bracketing the arclines used for wavelength calibration
;         Plot Atlas spectra in wavelength limits c.wlmin to c.wlmax

;Error   FATAL ERROR: Atlas file: xxx not found'
;message ERROR: Atlas shows no lines in specified wavelength range
;
;Procedures called;
;read_control - Returns control data in structure c
;printl       - Prints text message to log file
;
;************Procedure***********************************************
pro arc_atlas,c,h,f,spectra,yoff
read_control,c
;***********************set plot window******************************
window,xsize=fix(1.3*c.psize),ysize=fix(0.6*c.psize)
!P.MULTI = [0,1,2,0,0]  & !P.CHARSIZE=1
yscale = 2*float(c.ccdzero)*c.lwide/4.0
if c.arcscale gt 1 then yscale = yscale/float(c.arcscale)
;*Plot overlay of arc spectra showing positions of calibration lines*
;*****************shift spectra by offset************************
pixel   = indgen(fix(1.2*c.ymax/c.ybin)+max(yoff))-max(yoff)-fix(c.ymax/c.ybin/10)
specoff = fltarr(c.nfiber,fix(1.2*c.ymax/c.ybin)+max(yoff))
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then $
  specoff(i,max(yoff)-yoff(i)+fix(0.1*c.ymax/c.ybin):$
     max(yoff)-yoff(i)+fix(1.1*c.ymax/c.ybin)-1)=$
            spectra(8*(f(i).line-1)+5,*)
;plot overlay of arc spectra with markers showing calibration lines
;**********set lines indicating central range of plot*****************
mark = fltarr(fix(1.2*c.ymax/c.ybin)+max(yoff))
mark(where(pixel lt 0 or pixel gt (c.ymax/c.ybin-max(yoff)))) = yscale
mark(0) = 0      &     mark(fix(1.2*c.ymax/c.ybin)+max(yoff)-1) = 0
;***********Plot markers on overlay graphic***************************
tit = 'Overlay of offset spectra using reference line, '+strtrim(h.lamp,2)+' lamp'
plot,pixel,mark,background=c.white,color=c.black,xstyle=1,ystyle=1$
     ,title=tit,ytitle='e-/pixel',yrange=[0,yscale],linestyle=1,$
     xrange=[-0.1*c.ymax/c.ybin-max(yoff),fix(1.1*c.ymax/c.ybin)]
;**********shaded areas outside central range of plot*****************
polyfill,pixel,mark,color=c.blue
;*************plot offset spectra*************************************
for i = 0,c.nfiber-1 do  oplot,pixel,specoff(i,*),color=c.black
;*********add markers bracketing calibration lines********************
mark = fltarr(c.ymax/c.ybin+max(yoff))
for i = 0,c.narcline-1 do if c.apixc(i)-c.apixw(i) gt 1 and $
         c.apixc(i)+c.apixw(i)+2 lt c.ymax+max(yoff) then begin
   mark(c.apixc(i)-c.apixw(i))=yscale/2
   mark(c.apixc(i)+c.apixw(i))=yscale/2
endif
oplot,indgen(c.ymax+max(yoff)),mark,color=c.red
;*******Auto set atlas file and wavelength limits********************
;*******set default name for atlas file******************************
if strlen(strtrim(c.atlfile,2)) eq 0 then c.atlfile = h.lamp
;*******set default limits on wavelength range***********************
;*******if either limit not set in current control file**************
;using central wavelength, dispersion/mm and pixel size in header data
if c.wlmin eq 0.0 or c.wlmax eq 0.0 then begin
   wltot   = h.disperse*c.pixelsiz*c.ypixel/2.0
   pixcut  = fix(c.fiberdip/float(h.disperse))+2*c.fiberoff
   c.wlmin   = h.cenwave - wltot*(c.ypixel/2-c.yzero-pixcut)/float(c.ypixel)
   c.wlmax   = h.cenwave + wltot*(c.ymax+c.yzero-c.ypixel/2-pixcut)/float(c.ypixel)
endif
;*****get upper and lower wavelength limits for atlas data************
pixend = max(yoff)+fix(0.1*c.ymax/c.ybin)
pixcen = c.ymax/c.ybin - max(yoff)
atllo = c.wlmin - (c.wlmax-c.wlmin)*pixend/float(pixcen)
atlhi = c.wlmax + (c.wlmax-c.wlmin)*pixend/float(pixcen)
;******************read atlas data file*******************************
openr,nr,'control_standards'+path_sep()+c.atlfile+'.txt',/get_lun,ERROR=err
if err ne 0 then printl,c.log,'FATAL ERROR: Atlas file: '+c.atlfile+' not found'
if err ne 0 then stop
atlwl   = dblarr(5000)
atlid   = strarr(5000)
atlmag  = fltarr(5000)
i = 0
dummy ='x'
while not eof(nr) do begin
   readf,nr,s
   s = strtrim(s,2)
;**********wavelength calibration line******************************
   atlwl(i) = double(strmid(s,0,strpos(s,' ')))
;**********text ID of calibration line******************************
   atlid(i) = strtrim(strmid(s,strpos(s,' '),strpos(s,'(')-strpos(s,' ')))
;**********nominal magnitude of calibration line*********************
   atlmag(i) = strmid(s,strpos(s,'(')+1,strpos(s,')')-strpos(s,'('))
   i = i + 1
endwhile
close,nr     & free_lun,nr
atlwl  = atlwl(0:i-1)
atlid  = atlid(0:i-1)
atlmag = atlmag(0:i-1)
;**select part of atlas data arrays that fall with wavelength range**
;***get array indices equivalent to wavelength limits****************
index = where(atlwl lt atllo,nwllo)
index = where(atlwl lt atlhi,nwlhi)
;****flag error if there are no lines in this range******************
if (nwlhi-nwllo) eq 0 then printl,c.log,$
'ERROR: Atlas shows no lines in specified wavelength range'
if (nwlhi-nwllo) eq 0 then return
;**select part of atlas data arrays that fall with wavelength range**
atlwl  = atlwl(nwllo:nwlhi-1)
atlid  = atlid(nwllo:nwlhi-1)
atlmag = atlmag(nwllo:nwlhi-1)
;***limit number of lines to plot to number in wavelength range*******
if c.natl gt (nwlhi-nwllo) then c.natl = nwlhi - nwllo
;***limit number of lines to plot to max allowed*********************
if c.natl gt n_elements(c.atlwl) then c.natl = n_elements(c.atlwl)
;atlas for combined lamps contains +ve lines for lamp 1 and -ve for lamp 2
;*************Match scaling of positive & negative magnitudes********
index = where(atlmag lt 0.0,count)
if count gt 0 then atlmag(index) = atlmag(index)*max(atlmag)/abs(min(atlmag))/2.0
;*******select number (c.natl) lines showing highest magnitude*********
dummy    = abs(atlmag)
atlwl  = atlwl(reverse(sort(dummy)))
atlid  = atlid(reverse(sort(dummy)))
atlmag = atlmag(reverse(sort(dummy)))
atlwl  = atlwl(0:c.natl-1)
atlid  = atlid(0:c.natl-1)
atlmag = atlmag(0:c.natl-1)
;**reset order of arrays of Atlas line data  in increasing wavelength***
dummy    = atlwl
atlwl  = atlwl(sort(dummy))
atlid  = atlid(sort(dummy))
atlmag = atlmag(sort(dummy))
;******fill data arrays used to plot selected atlas lines***************
plotwl  = dblarr(3*c.natl)
plotmag = fltarr(3*c.natl)
for i = 0,c.natl-1 do begin
   plotwl(3*i)    = atlwl(i)
   plotwl(3*i+1)  = atlwl(i)
   plotwl(3*i+2)  = atlwl(i)
   plotmag(3*i+1) = atlmag(i)
endfor
;*********set scale for atlas plot**************************************
if c.atlscale ge 1 then yscale = 1.1*max(atlmag)/c.atlscale $
      else yscale = 1.1*max(atlmag)
;*******plot of selected atlas lines***********************************
plot,plotwl,plotmag,background=c.white,color=c.black,yrange=[0,yscale]$
  ,xtitle = 'Wavlength (A)',ytitle ='Magnitude',xstyle=1,thick=1.5$
  ,xrange=[atllo,atlhi],title='Arc lamp atlas using file - '+c.atlfile
if min(atlmag) lt 0 then oplot,plotwl,-plotmag,color=c.red,thick=1.5
oplot,[c.wlmin,c.wlmin],[0,yscale],linestyle=1,color=c.black
oplot,[c.wlmax,c.wlmax],[0,yscale],linestyle=1,color=c.black
 ;***********annotate plot with wavelength and type data****************
atltxt =strarr(c.natl)
for i = 0,c.natl-1 do begin
   atltxt(i) = string(atlwl(i),format='(F10.3)')+$
     ' '+strtrim(atlid(i),2)
   x = atlwl(i) +0.01*(atlhi-atllo)
   y = 0.1*max(yscale)
   XYOUTS,x,y,atltxt(i),charsize=0.8,orientation=90,color=c.black
endfor
;**********copy plot dimensions to control structure (c.atl)************
c.atl(0) = atllo
c.atl(1) = atlhi
c.atl(2) = yscale
c.atl(3) = max(yoff)
c.atlwl(0:c.natl-1) = atlwl(0:c.natl-1)
end