;*********Procedure write_file version 1_0***********************
;procedure write_file,file,c,h,f,image
;Function  write fits file with pipeline header (page 0 read by default)
;Option    write_file,file,c,h,f,image,page=# specifies page number

;Input:    Full file name including path but without .fit extension
;          File header data (c,h,f), array of specified page (image)
;
;Procedures called;None
;
;************Procedure********************************************
pro write_file,file,c,h,f,image,page=PAGE
;*******create blank fits file header*****************************
mkhdr, head,image
sxdelpar,head,'COMMENT'
;******set file type to accept extensions*************************
sxaddpar,head,'EXTEND'  ,'T'
;*****load general observation parameters (h) into header*********
tag = strupcase(tag_names(h))
for i = 0,n_elements(tag)-1 do sxaddpar,head,tag(i),h.(i)
;***load fiber specific observation parameters (f) into header****
for i = 0,c.nfiber-1 do begin
   sxaddpar, head, f(i).fib+'STAT',f(i).stat
   sxaddpar, head, f(i).fib+'LINE',strtrim(f(i).line,2)
   sxaddpar, head, f(i).fib+'TYPE',f(i).type
   sxaddpar, head, f(i).fib+'MAGN',f(i).magn
   sxaddpar, head, f(i).fib+'NAME',f(i).name
   sxaddpar, head, f(i).fib+'RA'  ,f(i).ra
   sxaddpar, head, f(i).fib+'DEC' ,f(i).dec
   sxaddpar, head, f(i).fib+'X'   ,f(i).x
   sxaddpar, head, f(i).fib+'Y'   ,f(i).y
   sxaddpar, head, f(i).fib+'GAIN',f(i).gain
   sxaddpar, head, f(i).fib+'SKY' ,f(i).sky
endfor
;******load single value control data into header**************
tag = strupcase(tag_names(c))
for i = 0,c.nparam-1 do sxaddpar,head,tag(i),c.(i)
;****** load non standard parameters into header***************
sxaddpar,head,'LOG     ',c.log
sxaddpar,head,'NPARAM',c.nparam
;*****load input file data for bias files into header***********
sxaddpar,head,'NBIAS   ',c.nbias
sxaddpar,head,'BIASFILE',c.biasfile
for i = 0,c.nbias-1 do begin
	D_NAME = 'DBIAS'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.dbias(i)
endfor
;*****load input file data for flat files into header***********
sxaddpar,head,'NFLAT   ',c.nflat
sxaddpar,head,'FLATFILE',c.flatfile
for i = 0,c.nflat-1 do begin
	D_NAME = 'DFLAT'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.dflat(i)
endfor
;*****load input file data for mask files into header***********
sxaddpar,head,'NMASK   ',c.nmask
sxaddpar,head,'MASKFILE',c.maskfile
for i = 0,c.nmask-1 do begin
	D_NAME = 'DMASK'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.dmask(i)
endfor
;*****load input file data for circ files into header***********
sxaddpar,head,'NCIRC   ',c.ncirc
sxaddpar,head,'CIRCFILE',c.circfile
for i = 0,c.ncirc-1 do begin
	D_NAME = 'DCIRC'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.dcirc(i)
endfor
;*****load input file data for arc files into header***********
sxaddpar,head,'ARCFILE ',c.arcfile
sxaddpar,head,'NARC    ',c.narc
for i = 0,c.narc-1 do begin
	D_NAME = 'DARC'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.darc(i)
endfor
;*****load input file data for star files into header***********
sxaddpar,head,'NSTAR   ',c.nstar
sxaddpar,head,'STARFILE',c.starfile
for i = 0,c.nstar-1 do begin
	D_NAME = 'DSTAR'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.dstar(i)
endfor
;*****load input file data for sky offset files into header****s*
sxaddpar,head,'NOSET   ',c.noset
sxaddpar,head,'OSETFILE',c.osetfile
for i = 0,c.noset-1 do begin
	D_NAME = 'DOSET'+strtrim(string(i),2)
	sxaddpar, head, D_NAME,c.doset(i)
endfor
;***************load table of arcline data into header***********
sxaddpar,head,'NARCLINE',c.narcline
for i = 0,c.narcline-1 do begin
	A_NAME = 'ACALWL'+strtrim(string(i),2)
	sxaddpar, head, A_NAME,c.acalwl(i)
	A_NAME = 'APIXC'+strtrim(string(i),2)
	sxaddpar, head, A_NAME,c.apixc(i)
	A_NAME = 'APIXW'+strtrim(string(i),2)
	sxaddpar, head, A_NAME,c.apixw(i)
	A_NAME = 'AFLAG'+strtrim(string(i),2)
	sxaddpar, head, A_NAME,c.aflag(i)
endfor
;********************write fits file******************************
outfile = file+'.fit'
;***********default setting writing image to page 0****************
if not keyword_set(page) then print, 'Writing file: '+outfile
if not keyword_set(page) then writefits,outfile,image,head
;***option setting writing image to specified page number*********
if keyword_set(page) then if page eq 0 then print, 'Writing file: '+outfile
if keyword_set(page) then if page eq 0 then writefits,outfile,image,head
if keyword_set(page) then if page gt 0 then writefits,outfile,image,/append
end
