;*********Procedure write_control version 1_0*****************
;Procedure:write_control,c
;Function:Write control data set (c) to ASCII file named*********
;         control_data.txt located in the pipeline directory
;Option:  read_control,c,file=xxx write control data to  file xxx
;         where xxx is the  file name including path
;
;Input   :None
;Output  :control data in structure (c)
;
;Procedures called: None
;
;************Procedure**********************************************
pro write_control,c,file=FILE
if keyword_set(file) then openw, nw,file, /get_lun else $
             openw, nw,'control_data.txt', /get_lun
;******write single parameter items of control data****************
tag = tag_names(c)
for i = 0,c.nparam-1 do printf,nw,c.(i),'	;',tag(i)
;***************Read Bias data file nos**********************
printf,nw,c.nbias,'	;NBIAS'
for i = 0,c.nbias-1 do printf,nw,c.dbias(i),'	;DBIAS(',strtrim(i,2),')'
;***************Read Flat data file nos**********************
printf,nw,c.nflat,'	;NFLAT'
for i = 0,c.nflat-1 do printf,nw,c.dflat(i),'	;DFLAT(',strtrim(i,2),')'
;***************Read Mask data file nos**********************
printf,nw,c.nmask,'	;NMASK'
if c.nmask gt 0 then for i = 0,c.nmask-1 do $
     printf,nw,c.dmask(i),'	;DMASK(',strtrim(i,2),')'
;***************Read Circ data file nos**********************
printf,nw,c.ncirc,'	;NCIRC'
if c.ncirc gt 0 then  for i = 0,c.ncirc-1 do $
     printf,nw,c.dcirc(i),'	;DCIRC(',strtrim(i,2),')'
;***************Read Arc data file nos**********************
printf,nw,c.narc ,'	;NARC'
for i = 0,c.narc -1 do printf,nw,c.darc(i), '	;DARC (',strtrim(i,2),')'
;***************Read Star data file nos**********************
printf,nw,c.nstar,'	;NSTAR'
for i = 0,c.nstar-1 do printf,nw,c.dstar(i), '	;DSTAR(',strtrim(i,2),')'
;***************Read offset sky data file nos**********************
printf,nw,c.noset,'	;NOSET'
if c.noset gt 0 then for i = 0,c.noset-1 do $
     printf,nw,c.doset(i), '	;DOSET(',strtrim(i,2),')'
;***************Write table of arcline data***********************
printf,nw,c.narcline,'	;NARCLINE'
for i = 0,c.narcline-1 do begin
   printf,nw,c.acalwl(i),'	;ACALWL(',strtrim(i,2),')'
   printf,nw,c.apixc(i),'	;APIXC(',strtrim(i,2),')'
   printf,nw,c.apixw(i),'	;APIXW(',strtrim(i,2),')'
   printf,nw,c.aflag(i),'	;AFLAG(',strtrim(i,2),')'
endfor
close,nw   &    free_lun,nw
end
