;******************Procedure view_plot version 1_0******************************
;Procedure 	View_plot,mode,c,h,f,mag,err
;Option     View_plot,mode,c,h,f,mag,err,/ps
;
;Function   Plots the output spectra for active fibers and saves copies to gif file
;           Option /ps saves plots to postscript files (.ps)
;
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;
;Report to log:Saving gif plot of median of ### sky fibers to c:/xxx/xxx
;              Saving gif plot(s) of xxx spectra to c:/xxx/xxx
;
;Report to log:Saving ps plots of median of ### sky fibers to c:/xxx/xxx
;option /ps    Saving ps plot(s) of xxx spectra to c:/xxx/xxx
;
;Procedures called:
;printl       - Prints text message to log file
;
;*****************************Procedure***************************************
pro view_plot,c,h,f,mag,err,PS=ps
;***************count number of sky, star and circle set up spectra***********
index = where(f.type eq 'S' and f.line gt 0,nsky)
index = where(f.type eq 'P' and f.line gt 0,nstar)
index = where(f.type eq 'C' and f.line gt 0,ncirc)
;**********************Set window for gif plot********************************
if not keyword_set(ps) then begin
   window,xsize=c.psize,ysize=fix(c.psize*0.25)
   !P.CHARSIZE=1  & !p.multi=0
   dummy='Saving gif plots'
endif
;**************Set output parameter for PostScript plot***********************
;*************A copy of plots is sent to the nominated output file************
;**Note the dimensions of the plot are fixed (15cm x 6cm) see below***********
if keyword_set(ps) then begin
   set_plot,'PS',/copy
   device,/portrait
   device,/encapsulated,/preview
   device,XSIZE =15
   device,YSIZE =6
   !P.CHARSIZE=0.8
   dummy='Saving PostScript plot'
endif
;******************************Plot median sky spectrum***********************
if nsky gt 0 then begin
;*********set file name for PostScript output*********************************
   if keyword_set(ps) then device,FILENAME=c.pdir+c.ptemp+strtrim(c.starfile,2)+'_M'+'SKY'+'.ps'
   printl,c.log,dummy+' of median of '+strtrim(nsky,2)+' sky fibers to '+c.pdir+c.ptemp
;**********plot spectrum and associated error*********************************
   tit = ' File '+strtrim(c.starfile,2)+'_M'+'SKY    '+c.rbname+'   Median of '+$
                                                      strtrim(nsky,2)+' fibers'
   if mean(mag(c.nfiber+1,*)) ge 20 then ymax = 10*mean(mag(c.nfiber+1,*))$
                else ymax = 200
   plot,mag(0,*),mag(c.nfiber+1,*),background=c.white,color=c.black,xstyle=1,title=tit,$
   xtitle = 'Wavelength (A)', ytitle ='e/pixel',yrange=[0,ymax]
   oplot,err(0,*),err(c.nfiber+1,*),color=c.red
   if keyword_set(ps) then DEVICE,/close_file
;********Save copy of plot to gif file (if not PostScript plot)***************
   if not keyword_set(ps) then WRITE_gif,c.pdir+c.ptemp+strtrim(c.starfile,2)$
                                             +'_M'+'SKY'+'.gif',TVRD()
endif
;**********************Plot star spectra**************************************
if nstar gt 1 then begin
   printl,c.log,dummy+' of individual spectra to '+c.pdir+c.ptemp
;******************loop through all star targets******************************
   for i = 0,c.nfiber-1 do if f(i).type eq 'P' or f(i).type eq 'S' then begin
;********************create file name for plot and output file****************
      fib = f(i).fib
      strput,fib,'M',strpos(fib,'F')
      file = strtrim(c.starfile,2)+'_'+fib
;*********set file name for PostScript output*********************************
      if keyword_set(ps) then device,FILENAME=c.pdir+c.ptemp+file+'.ps'
;**********plot spectrum and associated error*********************************
      tit = file+'  type '+f(i).type+'  SNR '+ strtrim(fix(mean(mag(i+1,*))/$
      mean(abs(err(i+1,*)))),2)+'    '+c.rbname+'   '+f(i).name
      if mean(mag(i+1,*)) gt 70 then ymax = 2*mean(mag(i+1,*)) else ymax = 200
      plot,mag(0,*),mag(i+1,*),background=c.white,color=c.black,xstyle=1,title=tit,$
         xtitle = 'Wavelength (A)', ytitle ='electrons/pixel',yrange=[0,ymax]
      oplot,err(0,*),err(i+1,*),color=c.red
;*************close PostScript output*****************************************
      if keyword_set(ps) then DEVICE,/close_file
;********Save copy of plot to gif file (if not PostScript plot)***************
      if not keyword_set(ps) then WRITE_gif,c.pdir+c.ptemp+file+'.gif',TVRD()
   endif
endif
;***************Plot individual star and sky files ********S*****************
if nstar eq 1 then begin
;********************create file name for plot and output file***************
   fib = f(c.fiberid-1).fib
   strput,fib,'M',strpos(fib,'F')
   file = strtrim(c.starfile,2)+'_'+fib
;*********set file name for PostScript output*********************************
   if keyword_set(ps) then device,FILENAME=c.pdir+c.ptemp+file+'.ps'
   printl,c.log,dummy+' of single target spectra to '+c.pdir+c.ptemp
   tit = file+'  type '+f(c.fiberid-1).type+'  SNR '+$
   strtrim(fix(mean(mag(1,*))/mean(abs(err(1,*)))),2)+'    '+c.rbname+'   '+f(c.fiberid-1).name
   if mean(mag(1,*)) gt 70 then ymax = 2*mean(mag(1,*)) else ymax = 200
;**********plot spectrum and associated error*********************************
   plot,mag(0,*),mag(1,*),background=c.white,color=c.black,xstyle=1,title=tit,$
         xtitle = 'Wavelength (A)', ytitle ='electrons/pixel',yrange=[0,ymax]
   oplot,err(0,*),err(1,*),color=c.red
;*************close PostScript output*****************************************
   if keyword_set(ps) then DEVICE,/close_file
;********Save copy of plot to gif file (if not PostScript plot)***************
   if not keyword_set(ps) then WRITE_gif,c.pdir+c.ptemp+file+'.gif',TVRD()
endif
;**********************Plot circle set up spectra*****************************
if ncirc gt 0 then begin
   printl,c.log,dummy+' of circle set up to '+c.pdir+c.ptemp
;******************loop through valid spectra*********************************
   for i = 0,c.nfiber-1 do if strcmp(f(i).type,'C')  then begin
      fib = f(i).fib
      strput,fib,'M',strpos(fib,'F')
      file = strtrim(c.starfile,2)+'_'+fib
;*********set file name for PostScript output*********************************
      if keyword_set(ps) then device,FILENAME=c.pdir+c.ptemp+file+'.ps'
      tit = file+'  type '+f(i).type+'  SNR '+$
           strtrim(fix(mean(mag(i+1,*))/mean(abs(err(i+1,*)))),2)+'   Circle'
      if mean(mag(i+1,*)) gt 70 then ymax = 2*mean(mag(i+1,*)) else ymax = 200
;**********plot spectrum and associated error*********************************
      plot,mag(0,*),mag(i+1,*),background=c.white,color=c.black,xstyle=1,title=tit,$
         xtitle = 'Wavelength (A)', ytitle ='electrons/pixel',yrange=[0,ymax]
      oplot,err(0,*),err(i+1,*),color=c.red
;*************close PostScript output*****************************************
      if keyword_set(ps) then DEVICE,/close_file
;********Save copy of plot to gif file (if not PostScript plot)***************
      if not keyword_set(ps) then WRITE_gif,c.pdir+c.ptemp+file+'.gif',TVRD()
   endif
endif
;***********************reset device after ps plot****************************
if strcmp(strupcase(!version.os_family),'UNIX') then set_plot,'X'
if strcmp(strupcase(!version.os_family),'WINDOWS') then set_plot,'WIN'
end
