;******************Procedure View version 1_0******************************
;Procedure 	View
;Function	View and save file headers and median output spectra in different formats
;      	   saves text copies of the file headers for input and output data files
;
;Options	   View,xxx,xxx returns a two data arrays containing output spectra magnitude and errors
;           View,/plot - plots the output spectra for active fibers and saves copies to file
;           View,/ps - creates PostScript plots of spectra of active fibers and saves to file
;           View,/text - saves the output spectra for active fibers to individual ASCII files
;           View,/attenuation - Saves a table and plot of fiber attenuations to log/ directory
;
;Input	   Target data file and files of intermediate and output spectra
;Output	   Plots and/or text files for individual spectra and/or a table of fiber attenuations
;
;Report to log	RUNNING PROCEDURE:View
;           Saving copy of AF2/WYFFOS header for file: r1234567
;           Saving copy of pipeline header for file: s1234567
;
;Error	FATAL ERROR: file not found:xxx
;message
;
;Procedures called;
;read_control - Returns control data in structure c
;read_file    - Reads pipeline header (c,h,f) and image of pipeline fits file
;View_plot    - Plots the output spectra for active fibers and saves copies to file
;View_text    - saves the output spectra for active fibers to individual ASCII files
;View_attn    - Saves a table and plot of fiber attenuations to log/ directory
;printl       - Prints text message to log file
;
;*****************************Procedure***************************************
;**returns arrays of magnitude(mag) and error (err) of median output spectra**
;****the format of these arrays is shown in section 2.3 of the developer notes
pro view,mag,err,TEXT=text,PLOT=plot,PS=ps,ATTENUATION=attenuation,IRAF=iraf
;***************Read control data in structure c******************************
read_control,c
printl,c.log,'RUNNING PROCEDURE:View
;****************save copy of raw data header*******************************
;*********open raw data file of the first star (target) file ***************
file = c.pdir+c.pdata+'r'+strtrim(c.starfile,2)+'.fit'
openr,nr,file,/get_lun,ERROR=err
;********if file exists then read header array (head)***********************
if err eq 0 then begin
   printl,c.log,'Saving copy of AF2/WYFFOS header for file: r'+strtrim(c.starfile,2)
   image =mrdfits(file,0,head)
;*******save header array (head) to file named r1234567.txt*****************
   openw,nw,c.pdir+c.ptemp+'r'+strtrim(c.starfile,2)+'.txt',/get_lun
   for i=0,n_elements(head)-1 do printf,nw,head(i)
   close,nw    &   free_lun,nw
endif
;****************save copy of output header*********************************
;*********open intermediate data file of the first star (target) file *******
file = c.pdir+c.pint+'s'+strtrim(c.starfile,2)+'.fit'
openr,nr,file,/get_lun,ERROR=err
;********if file exists then read header array (head)***********************
if err eq 0 then begin
   printl,c.log,'Saving copy of pipeline header for file: s'+strtrim(c.starfile,2)
   image =mrdfits(file,0,head)
;*******save header array (head) to file named s1234567.txt*****************
   openw,nw,c.pdir+c.ptemp+'s'+strtrim(c.starfile,2)+'.txt',/get_lun
   for i=0,n_elements(head)-1 do printf,nw,head(i)
   close,nw    &   free_lun,nw
endif
;**************************View median data**********************************
dfile = c.pdir+c.pspec+'q'+strtrim(c.starfile,2)+'.fit'
openr,nr,file,/get_lun,ERROR=err
if err ne 0 then printl,c.log,'FATAL ERROR: file not found:'+file
if err ne 0 then return
close,nr     & free_lun,nr
file = c.pdir+c.pspec+'q'+strtrim(c.starfile,2)
read_file,file,cc,h,f,mag,page=0
read_file,file,cc,h,f,err,page=1
;*********************execute options****************************************
;****************Calling view_plot  (option view,/plot)**********************
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;Function:Plots the output spectra for active fibers and saves copies to file
if keyword_set(plot)        then view_plot,c,h,f,mag,err
;****************Calling view_plot  (option view,/ps)**********************
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;Function:Creates PostScript plots of spectra of active fibers and saves  to file
if keyword_set(ps)          then view_plot,c,h,f,mag,err,/ps
;****************Calling view_plot  (option view,/plot)**********************
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;Function:Saves the output spectra for active fibers to individual ASCII files
if keyword_set(text)        then view_text,c,h,f,mag,err
;****************Calling view_plot  (option view,/plot)**********************
;Input:   Header data (c,h,f) and median output spectra (mag,err)
;Function:Saves a table and plot of fiber attenuations to log/ directoory
if keyword_set(attenuation) then view_attn,c,h,f
end
