;************Procedure sky_sub version 1_0******************************
;Procedure  sky_sub,nf,c,f,wl,starspec,starerr,skymed,skyerr
;
;Function   Subtract sky spectrum from star spectrum.
;            c.skytype=0:No sky spectrum is subtracted
;            c.skytype=1:linear subtraction of sky spectrum
;            c.skytype=2:sky spectrum scaled for 'optimum' subtraction
;            c.skytype=2:sky spectrum scaled and output masked over large sky lines
;
;Input:     fiber number counter (i) and header data (c,f)
;           common wavelegth scale (wl), star spectrum and its error
;           sky spectrum and its error
;Output:    sky subtracted star spectrum and error
;            header data updated to show fraction of sky spectrum subtracted
;           type of sky subtraction used set by parameter c.skytype
;
;Error    WARNING poor convergence of sky subtraction for fiber ###, scale parameter set to 1
;Message
;
;Procedures called:
;printl       - Prints text message to log file
;
;*****************Procedure**********************************************
pro sky_sub,nf,c,f,wl,starspec,starerr,skymed,skyerr
;***for skytype 0 set header f.sky=0  and return (with no subraction)****
f(nf).sky = 0
if c.skytype eq 0 then return
;********hold unmodified version of starspec in starspco*****************
starspeco = starspec
;*********linear subtraction of sky spectrum*****************************
starspec  = starspeco - skymed
;************add error in sky spectrum in quadrature*********************
starerr   = sqrt(starerr*starerr + skyerr*skyerr)
;*******for skytype 1 set header f.sky=1  and return**********************
f(nf).sky = 1
if c.skytype eq 1 then return
;*********************optimum sky subtraction****************************
;**********take ac component of sky spectrum*****************************
skyo  = skymed   - mean(skymed)
;**********take ac component of original star spectrum*******************
staro = starspeco - mean(starspeco)
;*******get zero offset convolution of these two spectra*****************
conv_zero = mean(staro*skyo)
;*********linear subtraction of sky spectrum*****************************
starspec = starspeco - skymed
;**********take ac component of sky subtracted spectrum******************
star = starspec - mean(starspec)
;*******get zero offset convolution of with ac sky spectrum**************
conv_unit = mean(star*skyo)
;**set f.sky to achieve to a zero convolution with ac sky spectrum*******
f(nf).sky = 1 + conv_unit/conv_zero
;*******subtract this optimum fraction of the sky spectrum***************
starspec = starspeco - f(nf).sky*skymed
;***********************reject poor convergence**************************
;**********take ac component of sky subtracted spectrum******************
star = starspec - mean(starspec)
;*******get zero offset convolution of with ac sky spectrum**************
conv_fin = mean(star*skyo)
;*******check for convergence********************************************
if abs(conv_fin) gt abs(conv_unit) then begin
   printl,c.log,'WARNING poor convergence of sky subtraction for fiber '+$
    strtrim(nf+1,2)+', scale parameter set to 1'
;***********In case of poor convergence set scaling parameter f.sky=1****
   f(nf).sky = 1
   starspec = starspeco - f(nf).sky*skymed
endif
;*******for skytype 2 return*********************************************
if c.skytype eq 2 then return
;*****Mask sky lines above level specified in control data***************
mask = intarr(n_elements(skymed))
mask(*) = 1
;************************Mask sky lines**********************************
;**define masking vector set to zero when sky signal exceed cut off level
index = where(skyo gt c.skymax,count)
if count gt 0 then mask(index) = 0
;**broaden masked sections to allow for any misalignment at line edges**
nwl = n_elements(wl)
mask(2:nwl-1) = mask(2:nwl-1)*mask(0:nwl-3)
mask(0:nwl-3) = mask(0:nwl-3)*mask(2:nwl-1)
;**********mask sky subtracted spectrum*********************************
starspecm = starspec*mask
starerrm  = starerr*mask
;******************************Interpolate masked data******************
;************set first and last point of mask to 1**********************
mask(0) = 1     &     mask(n_elements(mask)-1) = 1
;Set arrays to hold  pixel No., magnitude and variance of unmasked points
tempw = fltarr(n_elements(wl))
temps = fltarr(n_elements(wl))
tempe = fltarr(n_elements(wl))
;**initialise counter of number of pixels containing unmasked point*******
 j=0
;***fill arrays containing pixel No., mag and val for unmasked point******
for m = 0,n_elements(wl)-1 do begin
   tempw(j) = wl(m)
   temps(j) = starspecm(m)
   tempe(j) = starerrm(m)
 ;***increment counter if original spectra contains unmasked point**********
   if mask(m) ne 0 then j = j + 1
endfor
 ;*truncate arrays of wavelength., mag and var at max No. of unmasked points
tempw = tempw(0:j-1)
temps = temps(0:j-1)
tempe = tempe(0:j-1)
;*****interpolate data for unmasked points over all wavelength values*******
starspec=SPLINE(tempw,temps,wl)
starerr =SPLINE(tempw,tempe,wl)
end
