;***********Procedure read_control version 1_0*******************
;Procedure:read_control,c
;Function:Read control data set (c) from ASCII file named*********
;         control_data.txt located in the pipeline directory
;Option:  read_control,c,file=xxx read control data from a file xxx
;         where xxx is the  file name including path
;
;Input   :None
;Output  :control data in structure (c)
;
;Procedures called;None
;
;*****local function used to set consistent path separator(/)*****
function separater,path
for i = 0,10  do if  path_sep() ne '/' and strpos(path,'/') ge 0 then $
   strput,path,'\',strpos(path,'/')
return, path
end
;
;*****************procedure****************************************
pro read_control,c,FILE=file
;*******set structure for control data structure*******************
;**descriptors of control data are insection 1.1 of developer notes
c = {c,rbname:'x',pdir:'x',fiberid:0,dfiber1:0,dfiber2:0$
      ,skyoset:0,skytype:0,wlmin:0.0D,wlmax:0.0D$

      ,fibrattn:0,profile:0,flattype:0,nscatter:0,wltype:0$

      ,xbin:0,ybin:0,csize:0.0,maskcut:0.0,maskmax:0.0,masklev:0.0$
      ,circlev:0,circsmth:0,circzero:0.0,lwide:0,yavg:0,boxwide:0$
      ,staritn:0,nwl:0L,flatsmth:20$

      ,pdata:'x',pint:'x',pspec:'x',plog:'x',ptemp:'x'$

      ,biaserr:0.0,flaterr:0.0,sighi:0.0,siglo:0.0$
      ,extsigma:0,skymin:0.0,skymax:0.0,msigmax:0.0$

      ,ccdron:0.0D,ccdgain:0.0D,ypixel:0,yzero:0,ymax:0,ccdzero:0L$
      ,noscan:0,oscan1:0,oscan2:0,oscan3:0,oscan4:0,circcutl:0,circcutr:0$
      ,nfiber:0,nfiducl:0,rcircle:0.0D,dfiber3:0,dfiber4:0$
      ,fiberdip:0.0,fiberoff:0.0,pixelsiz:0.0$

      ,arcorder:0,arcwide:0,arcrefc:0,arcrefw:0,arcscale:0,afilecut:0$
      ,atlfile:'x',natl:0,atlscale:0,atlflag:0,atlaline:0$

      ,log:'x',nparam:0,flag1:0,flag2:0,flag3:0,flag4:0$
      ,atl:fltarr(4),atlwl:dblarr(50)$
      ,psize:0,black:0L,red:0L,blue:0L,white:0L$

      ,biasfile:0L,nbias:0,dbias:lonarr(21)$
      ,flatfile:0L,nflat:0,dflat:lonarr(11)$
      ,maskfile:0L,nmask:0,dmask:lonarr(5)$
      ,circfile:0L,ncirc:0,dcirc:lonarr(5)$
      ,arcfile :0L,narc :0,darc :lonarr(2)$
      ,starfile:0L,nstar:0,dstar:lonarr(11)$
      ,osetfile:0L,noset:0,doset:lonarr(11)$
      ,narcline:0,acalwl:dblarr(15)$
      ,apixc:lonarr(15),apixw:lonarr(15),aflag:intarr(15)}

;**************Open control_data file*****************************
if keyword_set(file) then openr, nr,file, /get_lun else $
             openr, nr,'control_data.txt', /get_lun
;******read single parameter items of control data****************
;*****note parameters are read in the order they are found in*****
;*therefore the contol file mist contain a list of all parameters
;*in the correct order with no blank lines************************
;****any comments following a semi-colon are not read*************
dummy = 'txt'
num   = 0L
val   = 0.0D
readf,nr,dummy    &   c.rbname  = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.rbname  =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,dummy  &   c.pdir  = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.pdir  =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,num    &   c.fiberid = num
readf,nr,num    &   c.dfiber1  = num
readf,nr,num    &   c.dfiber2  = num
readf,nr,num    &   c.skyoset  = num
readf,nr,num    &   c.skytype  = num
readf,nr,dummy  &   c.wlmin    = double(dummy)
readf,nr,dummy  &   c.wlmax    = double(dummy)
;***********read options***********************************
readf,nr,num    &   c.fibrattn = num
readf,nr,num    &   c.profile  = num
readf,nr,num    &   c.flattype = num
readf,nr,num    &   c.nscatter = num
readf,nr,num    &   c.wltype   = num
;***********read general setting***************************
readf,nr,num    &   c.xbin     = num
readf,nr,num    &   c.ybin     = num
readf,nr,val    &   c.csize    = val
readf,nr,val    &   c.maskcut  = val
readf,nr,num    &   c.maskmax  = num
readf,nr,val    &   c.masklev  = val
readf,nr,num    &   c.circlev  = num
readf,nr,num    &   c.circsmth = num
readf,nr,val    &   c.circzero = val
readf,nr,num    &   c.lwide    = num
readf,nr,num    &   c.yavg     = num
readf,nr,num    &   c.boxwide  = num
readf,nr,num    &   c.staritn  = num
readf,nr,num    &   c.nwl      = num
readf,nr,num    &   c.flatsmth = num
;*************read subdirectories***************************
readf,nr,dummy  &   c.pdata = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.pdata =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,dummy  &   c.pint  = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.pint  =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,dummy  &   c.pspec = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.pspec =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,dummy  &   c.plog  = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.plog  =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,dummy  &   c.ptemp = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.ptemp =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
;*************read limits**********************************
readf,nr,val    &   c.biaserr  = val
readf,nr,val    &   c.flaterr  = val
readf,nr,val    &   c.sighi    = val
readf,nr,val    &   c.siglo    = val
readf,nr,num    &   c.extsigma = num
readf,nr,val    &   c.skymin   = val
readf,nr,num    &   c.skymax   = num
readf,nr,val    &   c.msigmax  = val
;************read CCD/fiber properties**********************
readf,nr,val    &   c.ccdron   = val
readf,nr,val    &   c.ccdgain  = val
readf,nr,num    &   c.ypixel   = num
readf,nr,num    &   c.yzero    = num
readf,nr,num    &   c.ymax     = num
readf,nr,num    &   c.ccdzero  = num
readf,nr,num    &   c.noscan   = num
readf,nr,num    &   c.oscan1   = num
readf,nr,num    &   c.oscan2   = num
readf,nr,num    &   c.oscan3   = num
readf,nr,num    &   c.oscan4   = num
readf,nr,val    &   c.circcutl = val
readf,nr,val    &   c.circcutr = val
readf,nr,num    &   c.nfiber   = num
readf,nr,num    &   c.nfiducl  = num
readf,nr,val    &   c.rcircle  = val
readf,nr,num    &   c.dfiber3  = num
readf,nr,num    &   c.dfiber4  = num
readf,nr,val    &   c.fiberdip = val
readf,nr,val    &   c.fiberoff = val
readf,nr,val    &   c.pixelsiz = val
;**************read arcline parameters************************
readf,nr,num    &   c.arcorder = num
readf,nr,num    &   c.arcwide  = num
readf,nr,num    &   c.arcrefc  = num
readf,nr,num    &   c.arcrefw  = num
readf,nr,num    &   c.arcscale = num
readf,nr,num    &   c.afilecut = num
readf,nr,dummy  &   c.atlfile = strtrim(dummy,2)
if strpos(dummy,';') gt 0 then $
  c.atlfile =strtrim(strmid(dummy,0,strpos(dummy,';')-1),2)
readf,nr,num    &   c.natl     = num
readf,nr,num    &   c.atlscale = num
readf,nr,num    &   c.atlflag  = num
readf,nr,num    &   c.atlaline = num
;***************Read Bias data file nos**********************
readf,nr,num    &   c.nbias    = num
for i = 0,c.nbias - 1 do begin
   readf,nr,num &   c.dbias(i) = num
endfor
c.biasfile = c.dbias(0)
;***************Read Flat data file nos**********************
readf,nr,num    &   c.nflat    = num
for i = 0,c.nflat - 1 do begin
   readf,nr,num &   c.dflat(i) = num
endfor
c.flatfile = c.dflat(0)
;***************Read Mask data file nos**********************
readf,nr,num    &   c.nmask    = num
if c.nmask gt 0 then for i = 0,c.nmask - 1 do begin
   readf,nr,num &   c.dmask(i) = num
endfor
c.maskfile = c.dmask(0)
;***************Read Circ data file nos**********************
readf,nr,num    &   c.ncirc    = num
if c.ncirc gt 0 then for i = 0,c.ncirc - 1 do begin
   readf,nr,num &   c.dcirc(i) = num
endfor
if c.ncirc gt 0 then c.circfile = c.dcirc(0) $
         else c.circfile = c.flatfile
;***************Read Arc data file nos***********************
readf,nr,num    &   c.narc    = num
for i = 0,c.narc - 1 do begin
   readf,nr,num &   c.darc(i) = num
endfor
c.arcfile = c.darc(0)
;***************Read Star data file nos**********************
readf,nr,num    &   c.nstar   = num
for i = 0,c.nstar - 1 do begin
   readf,nr,num &   c.dstar(i) = num
endfor
c.starfile = c.dstar(0)
;***************Read offset sky data file nos****************
readf,nr,num    &   c.noset   = num
if c.noset gt 0 then for i = 0,c.noset - 1 do begin
   readf,nr,num &   c.doset(i) = num
endfor
c.osetfile = c.doset(0)
;******Read table of arcline data*****************************
readf,nr,num    &   c.narcline = num
for i = 0,c.narcline - 1 do begin
   readf,nr,val &   c.acalwl(i) = val
   readf,nr,num &   c.apixc(i)  = num
   readf,nr,num &   c.apixw(i)  = num
   readf,nr,num &   c.aflag(i)  = num
endfor
close,nr   &    free_lun,nr
;****Ensure that all file paths specify a consistent separator
  c.pdata = separater(c.pdata)
  c.pint  = separater(c.pint)
  c.plog  = separater(c.plog)
  c.pspec = separater(c.pspec)
  c.ptemp = separater(c.ptemp)
;*set total numbers for different types of control parameters*
;**these values are used to set table size in the GUI********
c.flag1  = 63        ;No  basic parameters
c.flag2  = 11        ;No arc parameters
;***set additional control parameters used in I/O procedures*
c.log = c.pdir+c.plog+c.rbname+'_log.txt'
c.nparam  = c.flag1 + c.flag2
;********set plot window parameters**************************
;**this is required to reset IDL settings after procedure ATV
;**has been run since can leave things in a strange state****
if strcmp(strupcase(!version.os_family),'UNIX') then set_plot,'X'
if strcmp(strupcase(!version.os_family),'WINDOWS') then set_plot,'WIN'
device,decomposed=1
;set parameter controlling scaling of plot window on screen*
;***c.psize sets the maximum pixel size used****************
;**according to the screen size (with a maximum of 1000)****
c.psize = 1000
if (get_screen_size())[0] lt c.psize then $
          c.psize=fix(0.9*(get_screen_size())[0])
;********set colours used for pipeline plot******************
siz = long(!d.table_size)
tvlct,bindgen(siz),bindgen(siz),bindgen(siz)
c.black = 1
c.red   = long(180.0*siz/256.0)
c.blue  = (siz-1)*siz + c.red*siz*siz
c.white = siz*siz*siz-1
end
