;*********************Procedure Pipeline version 1_0***********************
;Procedure 	Pipeline
;Function	Runs the pipeline  modules to extract spectra using project calibration data
;           Modules run  Flat > Circ > Arc > Offset > Star > Medan
;
;Options	   Pipeline,/full runs all modules generating bias and mask files and arcline data
; 	         Bias > Mask > Flat > Circ > Arc (with Atlas) > Offset > Star > Medan
; 	         Pipeline,/auto runs modules in auto mode
; 	         Use existing Bias and Mask files, no sky subtraction or wavelength calibration
; 	         Pipeline,/auto,/full runs all modules in auto mode
; 	         Generates new Bias and Mask files, no sky subtraction or wavelength calibration
;
;Input	Raw data files + intermediate Bias and Mask if available
;Output	Standard output for each module run
;
;Report to log	RUNNING PROCEDURE:Pipeline
;             	Using control file: xxx
; 	            Setting auto mode options: profile:1, fibbrattn:1, flattype:0, nscatter:1 (if applicable)
; 	            Then one of the following:
;  	             Running all modules in Auto mode
; 	                Using existing bias and mask files, running remaining modules in Auto mode
; 	                Running all modules
; 	                Using existing bias and mask files
; 	            Followed by standard reports for each pipeline model
;
;Error	ERROR: target file header different no. of fibers (#) and/or fiducials (#)
;message        Overwriting data in control file to match target data
; 	      ERROR: target file header shows different readout binning (X:#, Y:#)
; 	             Overwriting data in control file to match target data
; 	      FATAL ERROR: control file shows incompatible sky type
; 	                   Use skytype:0 or set offset sky for single fiber extraction
; 	      ERROR: intermediate Bias file not found - running Bias
; 	      FATAL ERROR: designated Bias file shows incompatible binning
; 	      ERROR: intermediate Mask file not found - running Mask
; 	      FATAL ERROR: designated Mask file shows incompatible binning
;
;;Procedures called;
;read_control - Returns control data in structure c
;read_data    - Reads pipeline header (c,h,f) and binary image of raw data file
;read_file    - Reads pipeline header (c,h,f) and image of pipeline fits file
;Bias         - Create a median bias file
;Mask         - Create mask of pixels for dark current above cut off level
;Flat         - Create a median flat image
;Circ         - Trace centreline of active fibers across raw data image
;Arc          - Calibrate wavelength against pixel position for active fibers
;Oset         - Optimal extraction of set of offset sky observations
;Star         - Optimal extraction of spectra for a set of star files
;Median       - Evaluate median values of extracted spectra
;write_file   - Writes pipeline header (c,h,f) and data array to fits file
;write_control- Write control data to current control file (control_data.txt)
;printl       - Prints text message to log file
;
;*****************Procedure***************************************************
pro Pipeline,AUTO=auto,FULL=full
;***************Read control data in structure c******************************
read_control,c
printl,c.log,'RUNNING PROCEDURE:Pipeline
;**********Create new log file using current reduction block name*************
openw,nw,c.log,/get_lun
close,nw        &   free_lun,nw
printl,c.log,'Using control file: '+c.rbname
;************read target header parameters (structure h and f)****************
read_data,c.starfile,c,h,f
;********* check number of fibers and number of fiducials*********************
if c.nfiber ne h.nfiber or h.nfiduc ne c.nfiducl then begin
   printl,c.log,'ERROR: target file header different no. of fibers ('+$
   strtrim(h.nfiber,2)+') and/or fiducials ('+strtrim(h.nfiduc,2)+')'
   c.nfiber  = h.nfiber
   c.nfiducl = h.nfiduc
;********on error update control file with star data file values**************
   printl,c.log,'  Overwriting data in control file to match target data'
   write_control,c
endif
;********************* check x and y binning**********************************
if c.xbin ne h.xbin or h.ybin ne c.ybin then begin
   printl,c.log,'ERROR: target file header shows different readout binning (X:'+$
   strtrim(h.xbin,2)+', Y:'+strtrim(h.ybin,2)+')'
   c.xbin  = h.xbin
   c.ybin  = h.ybin
;********on error update control file with star data file values**************
   printl,c.log,'  Overwriting data in control file to match target data'
   write_control,c
endif
;****If running in auto mode then set pipeline options to default values******
if keyword_set(auto) then begin
   c.profile  = 1
   c.fibrattn = 1
   c.flattype = 1
   c.nscatter = 1
   printl,c.log,'Setting auto mode options: '+$
   'profile:1, fibbrattn:1, flattype:1, nscatter:1
endif
;************Check sky subtraction option is compatible with other options*****
if c.fiberid gt 0 and c.fiberid lt c.nfiber and c.skytype gt 0 and $
  c.skyoset eq 0 and not keyword_set(auto) then begin
   printl,c.log,'FATAL ERROR: control file shows incompatible sky type'
   printl,c.log,'  Use skytype:0 or set offset sky for single fiber extraction'
   stop
end
;**********************Check bias and mask file*******************************
if not keyword_set(full) then begin
;***************check Bias file can be read***********************************
   openr,nr,c.pdir+c.pint+'b'+strtrim(c.biasfile,2)+'.fit',/get_lun,ERROR=err
   if err ne 0 then begin
;*************if Bias file not found then run Bias****************************
      printl,c.log,'ERROR: intermediate Bias file not found - running Bias'
      Bias
   endif else  begin
      close,nr     & free_lun,nr
   endelse
;*******check binning bias file is compatible with star data file values******
   read_file,c.pdir+c.pint+'b'+strtrim(c.biasfile,2),cb,hb,fb
   if c.xbin ne hb.xbin or hb.ybin ne c.ybin then begin
      printl,c.log,'FATAL ERROR: designated Bias file shows incompatible binning'
      return
   endif
;***********If mask file is required then check it can be read****************
   if c.nmask gt 0 then begin
      openr,nr,c.pdir+c.pint+'m'+strtrim(c.maskfile,2)+'.fit',/get_lun,ERROR=err
      if err ne 0 then begin
;*************if Mask file not found then run Mask****************************
         print,'ERROR: intermediate Mask file not found - running Mask'
         if err ne 0 then Mask
         read_file,c.pdir+c.pint+'m'+strtrim(c.maskfile,2),cm,hm,fm
      endif else begin
         close,nr     & free_lun,nr
         read_file,c.pdir+c.pint+'m'+strtrim(c.maskfile,2),cm,hm,fm
      endelse
;*******check binning mask file is compatible with star data file values******
      if c.xbin ne hm.xbin or hm.ybin ne c.ybin then begin
         printl,c.log,'FATAL ERROR: designated Mask file shows incompatible binning'
         return
      endif
   endif
endif
;***run pipeline modules in sequence according to the options selected*********
;**************Actions for running Pipeline,/full,/auto************************
if keyword_set(auto) and keyword_set(full) then begin
   printl,c.log,'Running all modules in Auto mode'
   Bias
   Mask,/auto
   flat
   Circ,/auto
   Star,/auto
   Medan,/auto
endif
;*************Actions for running Pipeline,/auto*******************************
if keyword_set(auto) and not keyword_set(full) then begin
   printl,c.log,'Using existing bias and mask files, '+$
    'running remaining modules in Auto mode'
   Flat
   Circ,/auto
   Star,/auto
   Medan,/auto
endif
;*************Actions for running Pipeline,/full*******************************
if keyword_set(full) and not keyword_set(auto) then begin
   printl,c.log,'Running all modules'
   Bias
   Mask
   Flat
   Circ
   Arc,/atlas
   Offset
   Star
   Medan
endif
;*************Actions for running Pipeline   (with no options selected)*******
if not keyword_set(full) and not keyword_set(auto)  then begin
   printl,c.log,'Using existing bias and mask files'
   Flat
   Circ
   Arc
   Offset
   Star
   Medan
endif
end