;************Procedure GUO version 1_0*********************
;procedure guo
;Function  View the ASCII files of control data
;           view fits files of reduced spectra using the ATV utility
;           run procedure view,/text to save ASCII copies of the median output spectra
;           run procedure view,/plot to save gif plots of the median output spectra
;           run procedure view,/ps to save PostScript plots of the median output spectra
;
;Procedures called;
;read_control  - Returns control data in structure c
;ATV           - View contents of a output spectra file using ATV utility
;View_plot    - Plots the output spectra for active fibers and saves copies to file
;View_ps      - Creates PostScript plots of spectra of active fibers and saves to file
;View_text    - saves the output spectra for active fibers to individual ASCII files
;printl        - Prints text message to log file
;
;**set of procedures relating to graphical user interface GUO.pro****
;
;*****local function used to set consistent path separator(/)*******
function local,path
for i = 0,10  do if  path_sep() ne '/' and strpos(path,'/') ge 0 then $
   strput,path,'\',strpos(path,'/')
return, path
end
;
;*****local procedure used to view a data file using ATV utility*****
;*****input control data (s) and file name (dfile)*******************
pro atv_GUO,s,nfile
;******check file exists*********************************************
file = s.pdir+s.pspec+nfile+'.fit'
openr,nr,file,/get_lun,ERROR=err
if err ne 0 then print,'File not found: '+file
if err ne 0 then return
close,nr     & free_lun,nr
;********load fits file header (head) and array (image)**************
image =mrdfits(file,0,head)
;*********run ATV using header and image data************************
atv,image,header=head
print,'ATV display of file: ',file
end

;******local procedure to define bitmap for ATV button***************
pro button_label,eye
eye = bytarr(11,7)
eye(3:3+7,1) = [0,0,1,1,1,1,0,0]
eye(3:3+7,2) = [0,1,0,0,0,0,1,0]
eye(3:3+7,3) = [1,0,0,1,1,0,0,1]
eye(3:3+7,4) = [0,1,0,0,0,0,1,0]
eye(3:3+7,5) = [0,1,1,1,1,1,0,0]
eye = cvttobm(eye)
end

;*************Button event procedures********************************
;
;*****Select and display a new set of control file ******************
pro GUO_control,event
widget_control,event.top,get_uvalue=s
pdir = s.pdir
path = local(s.pdir)
file = dialog_pickfile(filter='*.txt',path=PATH)
read_control,s,FILE=file
s.pdir = pdir
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUOa,s
end

;*****Select new project directory path (pdir)*********************
pro GUO_pdir,event
widget_control,event.top,get_uvalue=s
path = s.pdir
s.pdir = dialog_pickfile(/directory,path=path)
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUOa,s
end

;***Set the  control parameter flag3=2 for  the GUI to display advanced data
pro GUO_adv,event
widget_control,event.top,get_uvalue=s
s.flag3=2
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUOa,s
end

;***Set the  control parameter flag3=1 so the GUI to display arcline data
pro GUO_arc,event
widget_control,event.top,get_uvalue=s
s.flag3=1
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUOa,s
end

;********save the displayed control parameter to file (pdir+rbname+'.txt')
pro GUO_close,event
widget_control,event.top,get_uvalue=s
s.flag3=0
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUOa,s
end

;******run procedure view,/text to save ASCII copies of the median spectra
pro GUO_text,event
view,/text
widget_control,event.top,/destroy
end

;******run procedure view,/plot to save gf plots of the median spectra
pro GUO_plot,event
view,/plot
widget_control,event.top,/destroy
end

;******run procedure view,/ps to save PostScript plots of the median spectra
pro GUO_ps,event
view,/ps
widget_control,event.top,/destroy
end

;******close the display**********************************************
pro GUO_quit,event
widget_control,event.top,/destroy
end


;*********view data file using ATV file viewer *****************
;*the following 21 event procedures call the procedure atv_view*
;*for a specified output spectra file name**********************
pro pstar0atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(0),2)
atv_GUO,s,nfile
end

pro pstar1atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(1),2)
atv_GUO,s,nfile
end

pro pstar2atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(2),2)
atv_GUO,s,nfile
end

pro pstar3atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(3),2)
atv_GUO,s,nfile
end

pro pstar4atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(4),2)
atv_GUO,s,nfile
end

pro pstar5atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(5),2)
atv_GUO,s,nfile
end

pro pstar6atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(6),2)
atv_GUO,s,nfile
end

pro pstar7atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(7),2)
atv_GUO,s,nfile
end

pro pstar8atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(8),2)
atv_GUO,s,nfile
end

pro pstar9atv,event
widget_control,event.top,get_uvalue=s
nfile = 'p'+strtrim(s.dstar(9),2)
atv_GUO,s,nfile
end

pro qstar_atv,event
widget_control,event.top,get_uvalue=s
nfile = 'q'+strtrim(s.dstar(0),2)
atv_GUO,s,nfile
end

pro ooset_atv,event
widget_control,event.top,get_uvalue=s
nfile = 'o'+strtrim(s.doset(0),2)
atv_GUO,s,nfile
end

pro uauto_atv,event
widget_control,event.top,get_uvalue=s
nfile = 'u'+strtrim(s.dstar(0),2)
atv_GUO,s,nfile
end

;***************procedure GUOa**********************************
;Function   :Display graphical user interface
;           :the basic display comprises 10 rows labelled B to K (i.e. guib, guic etc)
;           :two further rows L and M are opened to display advanced/arcline data
;
;Input      :control data (s)
;
;Options    s.flag3=0 basic display
;           s.flag3=1 basic display + arcline dtat tables
;           s.flag3=2 basic display + advanced parameter tables
;
pro GUOa,s
;*******get bitmap to be used for ATV button********************
button_label,eye
;**********set array controlling pixel sizing of GUI*************
x = fix(s.csize*indgen(1000))
;*****************Base widget**********************************
GUOa   = widget_base(title = 'View output file',/column)

;*********************ROW B*************************************
;***************Control file text and button*******************
GUOb  = widget_base(GUOa,/row)
label  = widget_label(GUOb,value = 'Control file',/align_left,xsize=x(100))
val_control = widget_text(GUOb,value = s.rbname,scr_xsize=x(135))
browse1 = widget_button(GUOb,value='browse',event_pro='GUO_control',xsize=x(60))
;**************Project directory text and button****************
label = widget_label(GUOb,value = 'Data path  ',/align_right,xsize=x(320))
val_pdir  = widget_text(GUOb,scr_xsize=x(210),value=s.pdir)
browse2 = widget_button(GUOb,value='browse',event_pro='GUO_pdir',xsize=x(60))

;*********************ROW C************************************
;***************No. science text *******************************
GUOc  = widget_base(GUOa,/row)
label = widget_label(GUOc,value = 'No. science exposures ',/align_left,xsize=x(160))
fiberid = strtrim(indgen(s.fiberid),2)
if s.fiberid eq 0 or s.fiberid gt s.nfiber then fiberid = 'all '
val_nstar = widget_text(GUOc,value = strtrim(s.nstar,2),scr_xsize=x(50))
;***************No. offset text *******************************
label = widget_label(GUOc,value = 'No. offset sky ',/align_right,xsize=x(130))
fiberid = strtrim(indgen(s.fiberid),2)
if s.fiberid eq 0 or s.fiberid gt s.nfiber then fiberid = 'all '
val_noset = widget_text(GUOc,value = strtrim(s.noset,2),scr_xsize=x(50))
;***************fiberID text *******************************
label = widget_label(GUOc,value = 'Selected fibers    ',/align_right,xsize=x(145))
fiberid = strtrim(indgen(s.fiberid),2)
if s.fiberid eq 0 or s.fiberid gt s.nfiber then fiberid = 'all '
val_fiberid = widget_text(GUOc,value = fiberid,scr_xsize=x(50))

;**************fibers in gap text***********************
if s.dfiber1 eq 0 then ngap = '--' else ngap=strtrim(s.dfiber1,2)
label= widget_label(GUOc,value = 'Fibers in CCD gap   1st   ',$
                    /align_right,xsize=x(152))
val_dfiber1 = widget_text(GUOc,value = ngap,scr_xsize=x(50))
label= widget_label(GUOc,value = '2nd  ',/align_right,xsize=x(38))
if s.dfiber2 eq 0 then ngap = '--' else ngap=strtrim(s.dfiber2,2)
val_dfiber2 = widget_text(GUOc,value = ngap,scr_xsize=x(50))

;*********************ROW D************************************
;***************skytype text*******************************
GUOd  = widget_base(GUOa,/row)
label = widget_label(GUOd,value = 'Sky subtraction  ',/align_left,xsize=x(120))
listsky= ['none','linear','scaled','scaled + masked']
skytype = listsky(s.skytype)
val_skytype = widget_text(GUOd,value = skytype,scr_xsize=x(90))
;***************Skyoset text*******************************
label = widget_label(GUOd,value = 'Offset sky   ',/align_right,xsize=x(130))
option=['no','yes ']
val_skyoset  = widget_text(GUOd,value = option(s.skyoset),scr_xsize=x(50))
;***************Spectrum scaling*******************************
label = widget_label(GUOd,value = 'Spectrum scaling   ',/align_right,xsize=x(110))
option = ['relative to flat','absolute']
val_flattype = widget_text(GUOd,value = option(s.flattype),scr_xsize=x(85))
;**************Wavelength range text**************************
label = widget_label(GUOd,value = 'Wavelength range (A)    ',$
                          /align_right,xsize=x(144))
wlmin = string(s.wlmin,format='(f6.1)')
val_wlmin = widget_text(GUOd,value = wlmin,scr_xsize=x(58))
label= widget_label(GUOd,value = 'to  ',/align_right,xsize=x(30))
wlmax = string(s.wlmax,format='(f6.1)')
val_wlmax = widget_text(GUOd,value = wlmax,scr_xsize=x(58))

;*********************ROW E************************************
;***************TITLES*****************************************
guod  = widget_base(guoa,/row)
label = widget_label(guod,value = 'CALIBRATION FILES',xsize=x(260),/align_left)
label = widget_label(guod,value = 'EXTRACTION SETTINGS',xsize=x(220),/align_left)
label = widget_label(guod,value = 'SINGLE TARGET SPECTRA',xsize =x(250),/align_left)
label = widget_label(guod,value = 'MEDIAN TARGET SPECTRA',xsize=x(150),/align_right)

;******************ROWS F, G, H, I, J, K***********************
;******************Biasfile and No. text **********************
guof     = widget_base(guoa,/row)
label = widget_label(guof,value = 'Bias file ',scr_xsize=x(80))
val_bias  = widget_text(guof,scr_xsize=x(63),value=strtrim(s.dbias(0),2))
label   = widget_label(guof,value = '   No.',xsize=x(35))
num_bias  = widget_text(guof,value = strtrim(s.nbias,2),scr_xsize=x(35))

;******************Flatfile and No. text **********************
guog     = widget_base(guoa,/row)
label = widget_label(guog,value = 'Flat file ',scr_xsize=x(80))
val_flat  = widget_text(guog,scr_xsize=x(63),value=strtrim(s.dflat(0),2))
label   = widget_label(guog,value = '   No.',xsize=x(35))
num_flat  = widget_text(guog,value = strtrim(s.nflat,2),scr_xsize=x(35))

;******************Darkfile and No. text **********************
guoh     = widget_base(guoa,/row)
label = widget_label(guoh,value = 'Dark file ',scr_xsize=x(80))
if s.nmask eq 0 then maskfile='  ' else maskfile=strtrim(s.dmask(0),2)
val_mask  = widget_text(guoh,scr_xsize=x(63),value=maskfile)
label   = widget_label(guoh,value = '   No.',xsize=x(35))
if s.nmask eq 0 then nmask='--' else nmask = strtrim(s.nmask,2)
num_mask  = widget_text(guoh,value = strtrim(s.nmask,2),scr_xsize=x(35))

;******************Circfile and No. text **********************
guoi     = widget_base(guoa,/row)
label = widget_label(guoi,value = 'Circ file ',scr_xsize=x(80))
if s.ncirc eq 0 then circfile='  ' else circfile=strtrim(s.dcirc(0),2)
val_circ  = widget_text(guoi,scr_xsize=x(63),value=circfile)
label   = widget_label(guoi,value = '   No.',xsize=x(35))
if s.ncirc eq 0 then ncirc='--' else ncirc = strtrim(s.ncirc,2)
num_circ  = widget_text(guoi,value = ncirc,scr_xsize=x(35))

;******************First arcfile and No. text *****************
guoj     = widget_base(guoa,/row)
if s.narc eq 1 then label=widget_label(guoj,value='Arc file  ',xsize=x(80))
if s.narc eq 2 then label=widget_label(guoj,value='Arc file (1)',xsize=x(80))
val_arc1 = widget_text(guoj,scr_xsize=x(63),value=strtrim(s.darc(0),2))
label    = widget_label(guoj,value = '   No.',xsize=x(35))
num_bias  = widget_text(guoj,value = strtrim(s.narc,2),scr_xsize=x(35))

;******************Second arcfile and No. text *****************
guok     = widget_base(guoa,/row)
if s.narc eq 2 then begin
   label = widget_label(guok,value = 'Arc file (2)',xsize=x(80))
   val_arc2 = widget_text(guok,scr_xsize=x(63),value=strtrim(s.darc(1),2))
   gap = widget_label(guok,value = ' ',xsize=x(407))
endif else gap = widget_label(guok,value = ' ',xsize=x(590))
label = widget_label(guok,value = 'OUTPUT REDUCED SPECTRA',xsize=x(250),/align_left)


;******************ROWS F, G, H, I, J, K***********************
;***************Fiber attenuation text*************************
gap   = widget_label(guof,value = ' ',xsize=x(20))
label = widget_label(GUOf,value = 'Fiber attenuation   ',/align_left,xsize=x(110))
option = ['unit values','approx. values','standard values','local values']
val_fibrattn = widget_text(GUOf,value = option(s.fibrattn),scr_xsize=x(80))
;***************Scattered light text ***********************
gap   = widget_label(guog,value = ' ',xsize=x(20))
label = widget_label(GUOg,value = 'Scattered light  ',/align_left,xsize=x(110))
option = ['no action','subtracted']
val_nscatter = widget_text(GUOg,value = option(s.nscatter),scr_xsize=x(80))
;***************Extraction profile text ***********************
gap   = widget_label(guoh,value = ' ',xsize=x(20))
label = widget_label(GUOh,value = 'Extraction profile  ',/align_left,xsize=x(110))
option = ['optimum','top hat']
val_profile = widget_text(GUOh,value = option(s.profile),scr_xsize=x(80))
;***************Arc lamp atlas text ***************************
gap   = widget_label(guoi,value = ' ',xsize=x(20))
label = widget_label(GUOi,value = 'Arc lamp atlas  ',/align_left,xsize=x(110))
val_atlfile = widget_text(GUOi,value = s.atlfile,scr_xsize=x(80))
;*******Wavelength scale (log or linear) text ***********************
gap   = widget_label(guoj,value = ' ',xsize=x(20))
label = widget_label(GUOj,value = 'Wavelength scale  ',/align_left,xsize=x(110))
option = ['log','linear']
val_wltype = widget_text(GUOj,value = option(s.wltype),scr_xsize=x(80))

;******************ROWS F, G, H, I, J**************************
;Text boxes for single observation output spectra - only specified number (nstar) are displayed
;*********************Star file 0 text*************************
if s.nstar gt 0 then begin
   label = widget_label(GUOf,value = '1 ',xsize=x(53),/align_right)
   val_pstar0  = widget_text(GUOf,scr_xsize=x(58),value=strtrim(s.dstar(0),2))
   gap = widget_label(GUOf,value = ' ',xsize=x(7))
   dstar0atv = widget_button(GUOf,value=eye,event_pro='pstar0atv',xsize=x(20))
endif else label = widget_label(GUOf,value=' ',xsize=x(145))
;*********************Star file 1 text*************************
if s.nstar gt 1 then begin
   label = widget_label(GUOg,value = '2 ',xsize=x(53),/align_right)
   val_pstar1  = widget_text(GUOg,scr_xsize=x(58),value=strtrim(s.dstar(1),2))
   gap = widget_label(GUOg,value = ' ',xsize=x(7))
   dstar1atv = widget_button(GUOg,value=eye,event_pro='pstar1atv',xsize=x(20))
endif else label = widget_label(GUOg,value=' ',xsize=x(145))
;*********************Star file 2 text*************************
if s.nstar gt 2 then begin
   label = widget_label(GUOh,value = '3 ',xsize=x(53),/align_right)
   val_pstar2  = widget_text(GUOh,scr_xsize=x(58),value=strtrim(s.dstar(2),2))
   gap = widget_label(GUOh,value = ' ',xsize=x(7))
   dstar2atv = widget_button(GUOh,value=eye,event_pro='pstar2atv',xsize=x(20))
endif else label = widget_label(GUOh,value=' ',xsize=x(145))
;*********************Star file 3 text*************************
if s.nstar gt 3 then begin
   label = widget_label(GUOi,value = '4 ',xsize=x(53),/align_right)
   val_pstar3  = widget_text(GUOi,scr_xsize=x(58),value=strtrim(s.dstar(3),2))
   gap = widget_label(GUOi,value = ' ',xsize=x(7))
   dstar3atv = widget_button(GUOi,value=eye,event_pro='pstar3atv',xsize=x(20))
endif else label = widget_label(GUOi,value=' ',xsize=x(145))
;*********************Star file 4 text*************************
if s.nstar gt 4 then begin
   label = widget_label(GUOj,value = '5 ',xsize=x(53),/align_right)
   val_pstar4  = widget_text(GUOj,scr_xsize=x(58),value=strtrim(s.dstar(4),2))
   gap = widget_label(GUOj,value = ' ',xsize=x(7))
   dstar4atv = widget_button(GUOj,value=eye,event_pro='pstar4atv',xsize=x(20))
endif else label = widget_label(GUOj,value=' ',xsize=x(145))

;******************ROWS F, G, H, I, J**************************
;*********************Star file 5 text*************************
if s.nstar gt 5 then begin
   label = widget_label(GUOf,value = '6 ',xsize=x(33),/align_right)
   val_pstar5  = widget_text(GUOf,scr_xsize=x(58),value=strtrim(s.dstar(5),2))
   gap = widget_label(GUOf,value = ' ',xsize=x(7))
   dstar5atv = widget_button(GUOf,value=eye,event_pro='pstar5atv',xsize=x(20))
endif else label = widget_label(GUOf,value=' ',xsize=x(125))
;*********************Star file 6 text*************************
if s.nstar gt 6 then begin
   label = widget_label(GUOg,value = '7 ',xsize=x(33),/align_right)
   val_pstar6  = widget_text(GUOg,scr_xsize=x(58),value=strtrim(s.dstar(6),2))
   gap = widget_label(GUOg,value = ' ',xsize=x(7))
   dstar6atv = widget_button(GUOg,value=eye,event_pro='pstar6atv',xsize=x(20))
endif else label = widget_label(GUOg,value=' ',xsize=x(125))
;*********************Star file 7 text*************************
if s.nstar gt 7 then begin
   label = widget_label(GUOh,value = '8 ',xsize=x(33),/align_right)
   val_pstar7  = widget_text(GUOh,scr_xsize=x(58),value=strtrim(s.dstar(7),2))
   gap = widget_label(GUOh,value = ' ',xsize=x(7))
   dstar7atv = widget_button(GUOh,value=eye,event_pro='pstar7atv',xsize=x(20))
endif else label = widget_label(GUOh,value=' ',xsize=x(125))
;*********************Star file 8 text*************************
if s.nstar gt 8 then begin
   label = widget_label(GUOi,value = '9 ',xsize=x(33),/align_right)
   val_pstar8  = widget_text(GUOi,scr_xsize=x(58),value=strtrim(s.dstar(8),2))
   gap = widget_label(GUOi,value = ' ',xsize=x(7))
   dstar8atv = widget_button(GUOi,value=eye,event_pro='pstar8atv',xsize=x(20))
endif else label = widget_label(GUOi,value=' ',xsize=x(125))
;*********************Star file 9 text*************************
if s.nstar gt 9 then begin
   label = widget_label(GUOj,value = '10 ',xsize=x(33),/align_right)
   val_pstar9  = widget_text(GUOj,scr_xsize=x(58),value=strtrim(s.dstar(9),2))
   gap = widget_label(GUOj,value = ' ',xsize=x(7))
   dstar9atv = widget_button(GUOj,value=eye,event_pro='pstar9atv',xsize=x(20))
endif else label = widget_label(GUOj,value=' ',xsize=x(125))

;******************ROWS F, G, H, I, J**************************
;*********************Median star file*************************
gap = widget_label(GUOf,value = ' ',xsize=x(90))
val_qstar0  = widget_text(GUOf,scr_xsize=x(58),value=strtrim(s.dstar(0),2))
gap = widget_label(GUOf,value = ' ',xsize=x(7))
qstar_atv = widget_button(GUOf,value=eye,event_pro='qstar_atv',xsize=x(20))
;*********************Median offset file***********************
;Text box for median offset sky  spectra - only shown if offset sky used
if s.skyoset eq 1 then begin
   label = widget_label(GUOg,value = 'MEDIAN OFFSET SKY',xsize=x(175),/align_right)
   gap = widget_label(GUOh,value = ' ',xsize=x(90))
   val_dstar0  = widget_text(GUOh,scr_xsize=x(58),value=strtrim(s.doset(0),2))
   gap = widget_label(GUOh,value = ' ',xsize=x(7))
   qoset_atv = widget_button(GUOh,value=eye,event_pro='ooset_atv',xsize=x(20))
endif
;*********************Median star in auto mode*****************
;Text box for median  spectra in auto mode - only shown if file exists
file = s.pdir+s.pspec+'u'+strtrim(s.starfile,2)+'.fit'
openr,nr,file,/get_lun,ERROR=err
if err eq 0 then begin
   close,nr     & free_lun,nr
   label = widget_label(GUOi,value = 'MEDIAN TARGET /AUTO',xsize=x(175),/align_right)
   gap = widget_label(GUOj,value = ' ',xsize=x(90))
   val_dstar0  = widget_text(GUOj,scr_xsize=x(58),value=strtrim(s.dstar(0),2))
   gap = widget_label(GUOj,value = ' ',xsize=x(7))
   qoset_atv = widget_button(GUOj,value=eye,event_pro='uauto_atv',xsize=x(20))
endif
;********************ROW L*************************************
;****************Action buttons********************************
GUOl     = widget_base(GUOa,/row)
advanced = widget_button(GUOl,value=' Advanced',xsize=x(75),event_pro='GUO_adv')
arclines = widget_button(GUOl,value='Arc lines',xsize=x(75),event_pro='GUO_arc')
closeit  = widget_button(GUOl,value=' Close',xsize=x(75),event_pro='GUO_close')
gap      = widget_label(GUOl,value = ' ',xsize=x(350))
viewtext = widget_button(GUOl,value=' ASCII ',xsize=x(75),event_pro='GUO_text')
viewplot = widget_button(GUOl,value=' Plot gif',xsize=x(75),event_pro='GUO_plot')
viewps   = widget_button(GUOl,value=' Plot PS',xsize=x(75),event_pro='GUO_ps')
quitGUO  = widget_button(GUOl,value=' Quit  ',xsize=x(75),event_pro='GUO_quit')

;*********************Row L, M**********************************
;*********display 3 tables of advanced parameters (if flag3=2)*******************
if s.flag3 eq 2 then begin
;***********set length of table using No  basic parameters (c.flag1)**********
   s.flag4  = fix(s.flag1/3)
   if s.flag1 mod 3 gt 0 then s.flag4 = fix(s.flag1/3) +1 $
         else s.flag4 = fix(s.flag1/3)
 ;*******copy advanced data into 3 data lists (one for each table)*************
  list1  = strarr(1,s.flag4)
   list2  = strarr(1,s.flag4)
   list3  = strarr(1,s.flag4)
   for i  = 0,s.flag4-1 do  list1(0,i) = strtrim(s.(i),2)
   for i  = 0,s.flag4-1 do list2(0,i) = strtrim(s.(i+s.flag4),2)
   for i  = 0,s.flag1-2*s.flag4-1 do  $
             list3(0,i) = strtrim(s.(i+2*s.flag4),2)
  ;********copy tag names into 3 name lists (one for each table)****************
 note = 'c.'+strlowcase(tag_names(s))
   note1  = note(0:s.flag4-1)
   note2  = note(s.flag4:2*s.flag4-1)
   note3  = note(2*s.flag4:s.flag1-1)
;*********widgets to display the 3 tables of advanced data********************
   GUOl   = widget_base(GUOa,/row)
   label= widget_label(GUOl,value='ADVANCED SETTINGS')
    gap    = widget_label(GUOl,value = ' ',xsize=x(600))
   label= widget_label(GUOl,value='<CR> to update')
   GUOm   = widget_base(GUOa,/row)
   gap    = widget_label(GUOm,value = ' ',xsize=x(75))
   advance1=widget_table(GUOm,value=list1,row_labels=note1,column_width=x(100),$
                         /no_column_header)
   gap    = widget_label(GUOm,value = ' ',xsize=x(75))
   advance2=widget_table(GUOm,value=list2,row_labels=note2,column_width=x(100),$
                         /no_column_header)
   gap    = widget_label(GUOm,value = ' ',xsize=(75))
   advance3=widget_table(GUOm,value=list3,row_labels=note3,column_width=x(100),$
                         /no_column_header)
endif

;*********************ROW L, M**********************************
;*********display 2 tables of arcline parameters (if flag3=1)*******************
if s.flag3 eq 1 then begin
   note = 'c.'+strlowcase(tag_names(s))
;*******copy general arcline data into  data list for table 4*******************
   list4  = strarr(1,s.flag2+1)
   list4(0,0) = strtrim(s.narcline,2)
   for i = 0,s.flag2-1 do list4(0,i+1) = strtrim(s.(s.flag1+i),2)
 ;********copy tag names into list**********************************************
   note4  = strarr(s.flag2+1)
   note4(0) = 'c.narcline'
   note4(1:s.flag2) = note(s.flag1:s.flag1+s.flag2-1)
   for i  = 0,s.flag2-1 do if strpos(note4(i),';') ge 0 then $
       note4(i) = strmid(note4(i),strpos(note4(i),';')+1)
 ;********copy tag names into list**********************************************
   arc = strarr(4,s.narcline)
   arc(0,*) = strtrim(s.apixc(0:s.narcline-1),2)
   arc(1,*) = strtrim(s.apixw(0:s.narcline-1),2)
   arc(2,*) = strtrim(s.acalwl(0:s.narcline-1),2)
   arc(3,*) = strtrim(s.aflag(0:s.narcline-1),2)
 ;********set row and column labels**********************************************
  xind = ['Center pixel','+/- pixels','Wavelength','Set(0/1)']
   yind = strtrim(indgen(s.narcline)+1,2)
   width =[x(80),x(60),x(60),x(40)]
;*********widgets to display the 2 tables of arc data***************************
   GUOl   = widget_base(GUOa,/row)
   label = widget_label(GUOl,value='ARC LINES')
   gap   = widget_label(GUOl,value = ' ',xsize=x(600))
   label = widget_label(GUOl,value='<CR> to update')
   GUOm   = widget_base(GUOa,/row)
   gap    = widget_label(GUOm,value = ' ',xsize=x(80))
   arclist = widget_table(GUOm,value=list4,row_labels=note4,column_width=x(80),$
                          scroll=false,/no_column_header)
   gap    = widget_label(GUOm,value = ' ',xsize=x(100))
   if s.narcline gt s.flag2 then nline = s.flag2 else nline = s.narcline
   arctable=widget_table(GUOm,value=arc,column_labels=xind,$
                   row_labels=yind,column_width=width,scr_ysize=22*(nline+1))
endif

;***************event handler*************************************************
widget_control,GUOa,/realize
widget_control,GUOa,set_uvalue=s
xmanager,'View output file',GUOa,/no_block
end

;*************procedure GUI****************************************************
pro guo
;********if a version of GUI is  already running then do not open second*******
if xregistered('View output file') ne 0 then return
;*read the active control file (control_data.txt) from the pipeline directory**
read_control,s
;****run procedure GUIa to display the graphical user interface*****************
GUOa,s
end


