;************Procedure GUI version 1_0*********************
;procedure gui
;Function  Manage the ASCII files of control data as follow:
;               Read and display a set of control data from file
;               View specified  data files using the fits file view utility ATV
;               Edit the parameters of the control data and save to file
;               Save the displayed data set to file control_data.txt
;               Run the pipeline in Auto mode using the displayed data set
;               Pipeline parameters are listed in Section 1.1 of Developers notes
;
;Procedures called;
;read_control  - Returns control data in structure c
;pipeline,/auto- Run pipeline in auto mode
;ATV           - View contents of a fits data file using ATV utility
;write_control- Write control data to current control file (control_data.txt)
;printl        - Prints text message to log file
;
;**set of procedures relating to graphical user interface GUI.pro****
;
;*****local function used to set consistent path separator(/)*******
function separater,path
for i = 0,10  do if  path_sep() ne '/' and strpos(path,'/') ge 0 then $
   strput,path,'\',strpos(path,'/')
return, path
end

;*****local procedure used to view a data file using ATV utility*****
;*****input control data (s) and file name (dfile)*******************
pro atv_view,s,dfile
;******check file exists********************************************
file = s.pdir+s.pdata+'r'+strtrim(dfile,2)+'.fit'
openr,nr,file,/get_lun,ERROR=err
if err ne 0 then print,'File not found: '+file
if err ne 0 then return
close,nr     & free_lun,nr
;********load header************************************************
image =mrdfits(file,0,head)
;********load image array and set to zero (image)*******************
image =mrdfits(file,1)+s.ccdzero
;*********run ATV using header and image data***********************
atv,image,header=head
print,'ATV display of file: ',file
end

;******local procedure to define bitmap for ATV button**************
pro button_label,eye
eye = bytarr(11,7)
eye(3:3+7,1) = [0,0,1,1,1,1,0,0]
eye(3:3+7,2) = [0,1,0,0,0,0,1,0]
eye(3:3+7,3) = [1,0,0,1,1,0,0,1]
eye(3:3+7,4) = [0,1,0,0,0,0,1,0]
eye(3:3+7,5) = [0,1,1,1,1,1,0,0]
eye = cvttobm(eye)
end

;*************Button event procedures*******************************
;****Select and display a new set of control file ******************
pro rbtemplate,event
widget_control,event.top,get_uvalue=s
pdir = s.pdir
path = separater(s.pdir)
file = dialog_pickfile(filter='*.txt',path=PATH)
read_control,s,FILE=file
s.pdir = pdir
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Edit name of current control data set (rbname)****************
pro rbname,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.rbname=dummy
widget_control,event.top,set_uvalue=s
end

;*****Select new project directory path (pdir)*********************
pro pdir,event
widget_control,event.top,get_uvalue=s
path = s.pdir
s.pdir = dialog_pickfile(/directory,path=path)
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Set fiber number to extract or set to all (fiberid)*********
pro fiberid,event
widget_control,event.top,get_uvalue=s
s.fiberid = event.index
if event.index eq 0 then s.fiberid = 999
widget_control,event.top,set_uvalue=s
end

;*****Set offset sky yes or no  (skyoset)**************************
pro skyoset,event
widget_control,event.top,get_uvalue=s
s.skyoset = event.index
widget_control,event.top,set_uvalue=s
end

;*****Set type of sky subtraction (skytype)*************************
pro skytype,event
widget_control,event.top,get_uvalue=s
s.skytype = event.index
widget_control,event.top,set_uvalue=s
end

;**Set number of first fiber in gap between halves of CCD (dfiber1)*
pro dfiber1,event
widget_control,event.top,get_uvalue=s
if event.index eq 0 then s.dfiber1 = 0 else s.dfiber1 = event.index+69
widget_control,event.top,set_uvalue=s
end

;**Set number of second fiber in gap between halves of CCD (dfiber2)*
pro dfiber2,event
widget_control,event.top,get_uvalue=s
if event.index eq 0 then s.dfiber2 = 0 else s.dfiber2 = event.index+69
widget_control,event.top,set_uvalue=s
end

;*****Edit name of first data file for bias (dbias(0))***************
pro dbias,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dbias(0)=long(dummy)
s.dbias(0:s.nbias-1) = s.dbias(0) + indgen(s.nbias)
s.dbias(s.nbias:n_elements(s.dbias)-1) = 0L
widget_control,event.top,set_uvalue=s
end

;*****Edit number of bias files (nbias)******************************
pro nbias,event
widget_control,event.top,get_uvalue=s
s.nbias=event.index+1
s.dbias(0:s.nbias-1) = s.dbias(0) + indgen(s.nbias)
s.dbias(s.nbias:n_elements(s.dbias)-1) = 0L
widget_control,event.top,set_uvalue=s
end

;*****Edit name of first data file for flat (dflat(0))***************
pro dflat,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dflat(0)=long(dummy)
s.dflat(0:s.nflat-1) = s.dflat(0) + indgen(s.nflat)
s.dflat(s.nflat:n_elements(s.dflat)-1) = 0L
widget_control,event.top,set_uvalue=s
end

;*****Edit number of flat files (nflat)******************************
pro nflat,event
widget_control,event.top,get_uvalue=s
s.nflat=event.index+1
s.dflat(0:s.nflat-1) = s.dflat(0) + indgen(s.nflat)
s.dflat(s.nflat:n_elements(s.dflat)-1) = 0L
widget_control,event.top,set_uvalue=s
end

;*****Edit name of first data file for mask (dmask(0))***************
pro dmask,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dmask(0)=long(dummy)
widget_control,event.top,set_uvalue=s
end

;*****Edit number of mask files (nmask)******************************
pro nmask,event
widget_control,event.top,get_uvalue=s
s.nmask=event.index
if s.nmask gt 0 then begin
   s.dmask(0:s.nmask-1) = long(s.dmask(0)) + indgen(s.nmask)
   s.dmask(s.nmask:n_elements(s.dmask)-1) = 0L
endif
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Edit name of first data file for circ (dcirc(0))***************
pro dcirc,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dcirc(0)=long(dummy)
widget_control,event.top,set_uvalue=s
end

;*****Edit number of circ files (ncirc)******************************
pro ncirc,event
widget_control,event.top,get_uvalue=s
s.ncirc=event.index
if s.ncirc gt 0 then begin
   s.dcirc(0:s.ncirc-1) = long(s.dcirc(0)) + indgen(s.ncirc)
   s.dcirc(s.ncirc:n_elements(s.dcirc)-1) = 0L
endif
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Edit name of first data file for arc (darc(0))***************
pro darc0,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.darc(0)=long(dummy)
widget_control,event.top,set_uvalue=s
end

;*****Edit name of second data file for arc (darc(0))***************
pro darc1,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.darc(1)=long(dummy)
widget_control,event.top,set_uvalue=s
end

;*****Edit number of arc files (narc)******************************
pro narc,event
widget_control,event.top,get_uvalue=s
s.narc=event.index+1
if s.narc eq 1 then s.darc(1) = 0L
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Edit number of star files (nstar)******************************
pro nstar,event
widget_control,event.top,get_uvalue=s
nstar   = s.nstar
s.nstar = event.index + 1
if s.nstar gt nstar then for i = nstar,s.nstar-1 do $
if s.dstar(i) eq 0 then s.dstar(i)=s.dstar(i-1)
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****Edit number of offset sky files (noset)*************************
pro noset,event
widget_control,event.top,get_uvalue=s
noset   = s.noset
s.noset = event.index
if s.noset gt noset and noset gt 0 then for i = noset,s.noset-1 $
do s.doset(i)=s.doset(i-1)
if s.noset eq 0 then s.skyoset=0
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;*****edit minimum wavelength (wlmin)*********************************
pro wlmin,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.wlmin = dummy
widget_control,event.top,set_uvalue=s
end

;*****edit maximum wavelength (wlmax)*********************************
pro wlmax,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.wlmax = dummy
widget_control,event.top,set_uvalue=s
end

;******edit name of atlas file (atlfile)******************************
pro atlfile,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.atlfile = dummy
widget_control,event.top,set_uvalue=s
end

;******the following procedures edit the names of the star files*******
;****a maximum of 10 file names can be set using the GUI****************
pro dstar0,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(0) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar1,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(1) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar2,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(2) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar3,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(3) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar4,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(4) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar5,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(5) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar6,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(6) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar7,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(7) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar8,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(8) = dummy
widget_control,event.top,set_uvalue=s
end

pro dstar9,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.dstar(9) = dummy
widget_control,event.top,set_uvalue=s
end

;******the following procedures edit the names of offset sky files*****
;****a maximum of 5 file names can be set using the GUI****************
pro doset0,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.doset(0) = dummy
widget_control,event.top,set_uvalue=s
end

pro doset1,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.doset(1) = dummy
widget_control,event.top,set_uvalue=s
end

pro doset2,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.doset(2) = dummy
widget_control,event.top,set_uvalue=s
end

pro doset3,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.doset(3) = dummy
widget_control,event.top,set_uvalue=s
end

pro doset4,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.doset(4) = dummy
widget_control,event.top,set_uvalue=s
end

;***Set the  control parameter flag3=2 for  the GUI to display advanced data
pro GUI_adv,event
widget_control,event.top,get_uvalue=s
s.flag3=2
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;***Set the  control parameter flag3=1 so the GUI to display arcline data
pro GUI_arc,event
widget_control,event.top,get_uvalue=s
s.flag3=1
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;***Set the  control parameter flag3=0 so the GUI closes additional displays
pro GUI_close,event
widget_control,event.top,get_uvalue=s
s.flag3=0
widget_control,event.top,set_uvalue=s
widget_control,event.top,/destroy
GUIa,s
end

;********save the displayed control parameter to file (pdir+rbname+'.txt')
pro saveOB,event
widget_control,event.top,get_uvalue=s
file = s.pdir+s.rbname+'.txt'
print,'SAVING:',file
write_control,s,file=FILE
end

;******load the displayed control data as the active control file*******
pro loadOB,event
widget_control,event.top,get_uvalue=s
;********save the displayed control parameter to file (pdir+rbname+'.txt')
file = s.pdir+s.rbname+'.txt'
print,'SAVING: ',file
;***********also save to control_data.txt in the pipeline directory******
write_control,s,file=FILE
file = 'control.txt'
;***********also save to control_data.txt in the pipeline directory******
print,'COPY TO: ',file
write_control,s
;*********create new log file with new RB name (rbname)*******************
openw,nw,s.pdir+s.plog+s.rbname+'_log.txt',/get_lun
close,nw        &   free_lun,nw
s.log = s.pdir+s.plog+s.rbname+'_log.txt'
printl,s.log,'Loading control_file: '+s.rbname
end

;***run the pipeline in auto mode using the display set of control data**
;********save the displayed control parameter to file (pdir+rbname+'.txt')
pro autorun,event
widget_control,event.top,get_uvalue=s
file = s.pdir+s.rbname+'.txt'
print,'SAVING: ',file
write_control,s,file=FILE
file = 'control.txt'
;***********also save to control_data.txt in the pipeline directory******
print,'COPY TO: ',file
write_control,s
;*********create new log file with new RB name (rbname)*******************
openw,nw,s.pdir+s.plog+s.rbname+'_log.txt',/get_lun
close,nw        &   free_lun,nw
printl,s.log,'Loading control_file: '+s.rbname
;**********run procedure pipeline in auto mode***************************
Pipeline,/auto
widget_control,event.top,/destroy
end

;******close the GUI without saving the current set of control data*******
pro GUI_quit,event
widget_control,event.top,/destroy
end

;*********edit a data item in the LH table of advanced data***************
pro table1,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
for i = 0,s.flag4-1 do s.(i) = dummy(0,i)
widget_control,event.top,set_uvalue=s
end

;*********edit a data item in the centre table of advanced data***************
pro table2,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
for i = 0,s.flag4-1 do s.(s.flag4+i) = dummy(0,i)
widget_control,event.top,set_uvalue=s
end

;*********edit a data item in the RH table of advanced data***************
pro table3,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
for i = 0,s.flag1-2*s.flag4-1 do $
     s.(2*s.flag4+i) = dummy(0,i)
widget_control,event.top,set_uvalue=s
end

;**********edit table of general arc parameters*******************************
pro arclist,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
s.narcline = dummy(0,0)
for i = 0,s.flag2-1 do s.(s.flag1+i) = dummy(0,i+1)
widget_control,event.top,set_uvalue=s
end

;***********edit table of arc calibration lines******************************
pro arctable,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
for i = 0,s.narcline-1 do begin
  s.apixc(i)  = dummy(0,i)
  s.apixw(i)  = dummy(1,i)
  s.acalwl(i) = dummy(2,i)
  s.aflag(i)  = dummy(3,i)
endfor
widget_control,event.top,set_uvalue=s
end

;*********view data file using ATV file viewer *****************
;*the following 21 event procedures call the procedure atv_view*
;*for a specified dta file name*********************************
pro biasatv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dbias(0)
end

pro flatatv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dflat(0)
end

pro maskatv,event
widget_control,event.top,get_uvalue=s
if s.nmask gt 0 then atv_view,s,s.dmask(0)
end

pro circatv,event
widget_control,event.top,get_uvalue=s
if s.ncirc gt 0 then atv_view,s,s.dcirc(0)
end

pro arc0atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.darc(0)
end

pro arc1atv,event
widget_control,event.top,get_uvalue=s
if s.narc eq 2 then atv_view,s,s.darc(1)
end

pro dstar0atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(0)
end

pro dstar1atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(1)
end

pro dstar2atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(2)
end

pro dstar3atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(3)
end

pro dstar4atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(4)
end

pro dstar5atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(5)
end

pro dstar6atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(6)
end

pro dstar7atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(7)
end

pro dstar8atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(8)
end

pro dstar9atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.dstar(9)
end

pro doset0atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.doset(0)
end

pro doset1atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.doset(1)
end

pro doset2atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.doset(2)
end

pro doset3atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.doset(3)
end

pro doset4atv,event
widget_control,event.top,get_uvalue=s
atv_view,s,s.doset(4)
end
;
;***************procedure GUIa**********************************
;Function   :Display graphical user interface
;           :the basic display comprises 10 rows labelled B to K (i.e. guib, guic etc)
;           :two further rows L and M are opened to display advanced/arcline data
;
;Input      :control data (s)
;
;Options    s.flag3=0 basic display
;           s.flag3=1 basic display + arcline dtat tables
;           s.flag3=2 basic display + advanced parameter tables
;
pro GUIa,s
;*******get bitmap to be used for ATV button********************
button_label,eye
;**********set array controlling pixel sizing of GUI*************
x = fix(s.csize*indgen(1000))
;*****************Base widget and title of GUI******************
GUIa   = widget_base(title = 'Control File Editor',/column)

;*********************ROW B*************************************
;***************Template file text and button*******************
GUIb  = widget_base(GUIa,/row)
label  = widget_label(GUIb,value = 'Template file',xsize=x(100))
val_template  = widget_text(GUIb,value = s.rbname,scr_xsize=x(132))
browse1 = widget_button(GUIb,value='browse',event_pro='rbtemplate',xsize=x(60))
;***************rbname text*************************************
label = widget_label(GUIb,value = 'Save as   ',/align_right,xsize=x(80))
val_rbname  = widget_text(GUIb,scr_xsize=x(132),/edit,event_pro='rbname',$
                         /all_events,value=s.rbname)
;**************Project directory text and button****************
label = widget_label(GUIb,value = 'Data path  ',/align_right,xsize=x(100))
val_pdir  = widget_text(GUIb,scr_xsize=x(208),value=s.pdir)
browse2 = widget_button(GUIb,value='browse',event_pro='pdir',xsize=x(60))

;*********************ROW C************************************
;***************fiberID droplist*******************************
GUIc  = widget_base(GUIa,/row)
label = widget_label(GUIc,value = 'All/Single fibers',xsize=x(100))
id     =  strtrim(indgen(s.nfiber+1),2)
id(0)  = 'all '
fiberid  = widget_combobox(GUIc,value = id,event_pro='fiberid',xsize=x(50))
widget_control,fiberid,set_combobox_select=s.fiberid
;***************skyoset droplist*******************************
label = widget_label(GUIc,value = 'Offset sky   ',/align_right,xsize=x(80))
if s.noset gt 0 then option=['no','yes '] else option=['no']
val_noset  = widget_droplist(GUIc,value = option,event_pro='skyoset',xsize=x(50))
widget_control,val_noset,set_droplist_select=s.skyoset
;***************Skytype droplist*******************************
label = widget_label(GUIc,value = 'Sky subtraction  ',/align_right,xsize=x(150))
listsky= ['none','linear','scaled','scaled + masked']
val_skytype  = widget_droplist(GUIc,value = listsky,event_pro='skytype',xsize=x(85))
widget_control,val_skytype,set_droplist_select=s.skytype
;**************1st fiber in gap droplist***********************
ngap   =  strtrim(indgen(22)+69,2)
ngap(0)= '--'
label= widget_label(GUIc,value = 'Fibers in CCD gap     1st ',$
                    /align_right,xsize=x(212))
val_dfiber1 = widget_droplist(GUIc,value = ngap,event_pro='dfiber1',xsize=x(50))
if s.dfiber1 eq 0 then widget_control,val_dfiber1,set_droplist_select=0 else $
   widget_control,val_dfiber1,set_droplist_select=s.dfiber1-69
;***************2nd fiber in gap droplist**********************
label= widget_label(GUIc,value = '2nd  ',/align_right,xsize=x(40))
val_dfiber2 = widget_droplist(GUIc,value = ngap,event_pro='dfiber2',xsize=x(50))
if s.dfiber2 eq 0 then widget_control,val_dfiber2,set_droplist_select=0 else $
   widget_control,val_dfiber2,set_droplist_select=s.dfiber2-69

;*********************ROW D************************************
;***************TITLES*****************************************
GUId  = widget_base(GUIa,/row)
label = widget_label(GUId,value = 'CALIBRATION FILES',xsize=x(290),/align_left)
label = widget_label(GUId,value = 'OBSERVATION DATA',xsize=x(205),/align_left)
label = widget_label(GUId,value = 'TARGET FILES',xsize =x(280),/align_left)
if s.noset gt 0 then label = widget_label(GUId,value = 'OFFSET SKY FILES',$
                                          xsize=x(100),/align_left)

;******************ROWS E, F, G, H, I, J***********************
;******************Biasfile text and droplist******************
GUIe     = widget_base(GUIa,/row)
label = widget_label(GUIe,value = 'Bias file ',xsize=x(80))
val_bias  = widget_text(GUIe,scr_xsize=x(58),/edit,event_pro='dbias',$
                        /all_events,value=strtrim(s.dbias(0),2))
gap = widget_label(GUIe,value=' ',xsize=x(7))
biasatv = widget_button(GUIe,value=eye,event_pro='biasatv',xsize=x(20))
label   = widget_label(GUIe,value = '   No.',xsize=x(30))
nfile   =  strtrim(indgen(n_elements(s.dbias))+1,2)
num_bias  = widget_droplist(GUIe,value = nfile,event_pro='nbias',xsize=x(50))
widget_control,num_bias,set_droplist_select=s.nbias-1

;******************Flatfile  text and droplist*****************
GUIf     = widget_base(GUIa,/row)
label = widget_label(GUIf,value = 'Flat file ',xsize=x(80))
val_flat  = widget_text(GUIf,scr_xsize=x(58),/edit,event_pro='dflat',$
                        /all_events,value=strtrim(s.dflat(0),2))
gap = widget_label(GUIf,value=' ',xsize=x(7))
flatatv = widget_button(GUIf,value=eye,event_pro='flatatv',xsize=x(20))
label   = widget_label(GUIf,value = '   No.',xsize=x(30))
nfile  =  strtrim(indgen(n_elements(s.dflat))+1,2)
num_flat  = widget_droplist(GUIf,value = nfile,event_pro='nflat',xsize=x(50))
widget_control,num_flat,set_droplist_select=s.nflat-1

;******************Maskfile text and droplist*******************
GUIg     = widget_base(GUIa,/row)
label = widget_label(GUIg,value = 'Dark file ',xsize=x(80))
if s.nmask gt 0 then maskfile = s.dmask(0) else maskfile=''
val_mask  = widget_text(GUIg,scr_xsize=x(58),/edit,event_pro='dmask',$
                        /all_events,value=strtrim(maskfile,2))
gap = widget_label(GUIg,value = ' ',xsize=x(7))
maskatv  = widget_button(GUIg,value=eye,event_pro='maskatv',xsize=x(20))
label    = widget_label(GUIg,value = '   No.',xsize=x(30))
nfile    =  strtrim(indgen(n_elements(s.dmask)+1),2)
nfile(0) = '--'
num_mask = widget_droplist(GUIg,value = nfile,event_pro='nmask',xsize=x(50))
widget_control,num_mask,set_droplist_select=s.nmask

;******************Circfile text and droplist*******************
GUIh     = widget_base(GUIa,/row)
label    = widget_label(GUIh,value = 'Circ file ',xsize=x(80))
if s.ncirc gt 0 then circfile = s.dcirc(0) else circfile=''
val_circ = widget_text(GUIh,scr_xsize=x(58),/edit,event_pro='dcirc',$
                       /all_events,value=strtrim(circfile,2))
gap = widget_label(GUIh,value = ' ',xsize=x(7))
circatv = widget_button(GUIh,value=eye,event_pro='circatv',xsize=x(20))
label   = widget_label(GUIh,value = '   No.',xsize=x(30))
nfile    = strtrim(indgen(n_elements(s.dcirc)+1),2)
nfile(0) = '--'
num_circ  = widget_droplist(GUIh,value = nfile,event_pro='ncirc',xsize=x(50))
widget_control,num_circ,set_droplist_select=s.ncirc

;******************First arcfile text and droplist***************
GUIi     = widget_base(GUIa,/row)
if s.narc eq 1 then label = widget_label(GUIi,value = 'Arc file  ',xsize=x(80))
if s.narc eq 2 then label = widget_label(GUIi,value = 'Arc file (1)',xsize=x(80))
val_arc0  = widget_text(GUIi,scr_xsize=x(58),/edit,event_pro='darc0',$
                        /all_events,value=strtrim(s.darc(0),2))
gap = widget_label(GUIi,value = ' ',xsize=x(7))
arc0atv = widget_button(GUIi,value=eye,event_pro='arc0atv',xsize=x(20))
label   = widget_label(GUIi,value = '   No.',xsize=x(30))
narc  =  ['1','2']
num_arc  = widget_droplist(GUIi,value = narc,event_pro='narc',xsize=x(50))
widget_control,num_arc,set_droplist_select=s.narc-1

;***Second arcfile text and droplist (displayed if narcline=2)******
GUIj     = widget_base(GUIa,/row)
if s.narc eq 2 then begin
   label = widget_label(GUIj,value = 'Arc file (2)',xsize=x(80))
   val_arc1  = widget_text(GUIj,scr_xsize=x(58),/edit,event_pro='darc1',$
                           /all_events,value=strtrim(s.darc(1),2))
   gap = widget_label(GUIj,value = ' ',xsize=x(7))
   arc1atv = widget_button(GUIj,value=eye,event_pro='arc1atv',xsize=x(20))
   gap = widget_label(GUIj,value = ' ',xsize=x(407))
endif else gap = widget_label(GUIj,value = ' ',xsize=x(590))
label = widget_label(GUIj,value = 'ACTIONS',xsize=x(80),/align_left)

;*************************ROWS E, F, G, H, I*************************
;****************************nstar droplist**************************
gap = widget_label(GUIe,value = ' ',xsize=x(35))
label = widget_label(GUIe,value = 'No. science exposures ',xsize=x(107),/align_left)
nstar  =  strtrim(indgen(10)+1,2)
num_star  = widget_droplist(GUIe,value = nstar,event_pro='nstar',xsize=x(50))
widget_control,num_star,set_droplist_select=s.nstar-1

;******************noffset droplist************************
gap = widget_label(GUIf,value = ' ',xsize=x(35))
label = widget_label(GUIf,value = 'No. offset exposures ',xsize=x(107),/align_left)
noset  =  strtrim(indgen(6),2)
num_oset  = widget_droplist(GUIf,value = noset,event_pro='noset',xsize=x(50))
widget_control,num_oset,set_droplist_select=s.noset

;******************wlmin text*******************************
gap = widget_label(GUIg,value = ' ',xsize=x(35))
label = widget_label(GUIg,value = 'Min. wavelength (A)  ',xsize=x(105),/align_left)
val_wlmin  = widget_text(GUIg,scr_xsize=x(52),ysize=1,/edit,event_pro='wlmin',$
                        /all_events,value=string(s.wlmin,format='(f8.1)'))

;******************wlmax text*******************************
gap = widget_label(GUIh,value = ' ',xsize=x(35))
label = widget_label(GUIh,value = 'Max. wavelength (A)  ',xsize=x(105),/align_left)
val_wlmax  = widget_text(GUIh,scr_xsize=x(52),ysize=1,/edit,event_pro='wlmax',$
                      /all_events,value=string(s.wlmax,format='(f8.1)'))

;******************atlas text*******************************
gap = widget_label(GUIi,value = ' ',xsize=x(35))
label25 = widget_label(GUIi,value = 'Atlas file name ',xsize=x(80),/align_left)
text25  = widget_text(GUIi,scr_xsize=x(78),ysize=1,/edit,event_pro='atlfile',$
                      /all_events,value=s.atlfile)

;******************ROWS E, F, G, H, I*******************************
;Text boxes for star file names - only the specified number (nstar) are displayed
;******************dstar(0) text******************************
if s.nstar gt 0 then begin
   label = widget_label(GUIe,value = '1 ',xsize=x(53),/align_right)
   val_dstar0  = widget_text(GUIe,scr_xsize=x(58),/edit,event_pro='dstar0',$
                             value=strtrim(s.dstar(0),2),/all_events)
   gap = widget_label(GUIe,value = ' ',xsize=x(7))
   dstar0atv = widget_button(GUIe,value=eye,event_pro='dstar0atv',xsize=x(20))
endif else label = widget_label(GUIe,value=' ',xsize=x(150))
;******************dstar(1) text*****************
if s.nstar gt 1 then begin
   label = widget_label(GUIf,value = '2 ',xsize=x(53),/align_right)
   val_dstar1  = widget_text(GUIf,scr_xsize=x(58),/edit,event_pro='dstar1',$
                             value=strtrim(s.dstar(1),2),/all_events)
   gap = widget_label(GUIf,value = ' ',xsize=x(7))
   dstar1atv = widget_button(GUIf,value=eye,event_pro='dstar1atv',xsize=x(20))
endif else label = widget_label(GUIf,value=' ',xsize=x(150))
;******************dstar(2) text*****************
if s.nstar gt 2 then begin
   label = widget_label(GUIg,value = '3 ',xsize=x(53),/align_right)
   val_dstar2  = widget_text(GUIg,scr_xsize=x(58),/edit,event_pro='dstar2',$
                             value=strtrim(s.dstar(2),2),/all_events)
   gap = widget_label(GUIg,value = ' ',xsize=x(7))
   dstar2atv = widget_button(GUIg,value=eye,event_pro='dstar2atv',xsize=x(20))
endif else label = widget_label(GUIg,value=' ',xsize=x(150))
;******************dstar(3) text*****************
if s.nstar gt 3 then begin
   label = widget_label(GUIh,value = '4 ',xsize=x(53),/align_right)
   val_dstar3  = widget_text(GUIh,scr_xsize=x(58),/edit,event_pro='dstar3',$
                             value=strtrim(s.dstar(3),2),/all_events)
   gap = widget_label(GUIh,value = ' ',xsize=x(7))
   dstar3atv = widget_button(GUIh,value=eye,event_pro='dstar3atv',xsize=x(20))
endif else label = widget_label(GUIh,value=' ',xsize=x(150))
;******************dstar(4) text*****************
if s.nstar gt 4 then begin
   label = widget_label(GUIi,value = '5 ',xsize=x(53),/align_right)
   val_dstar4  = widget_text(GUIi,scr_xsize=x(58),/edit,event_pro='dstar4',$
                             value=strtrim(s.dstar(4),2),/all_events)
   gap = widget_label(GUIi,value = ' ',xsize=x(7))
   dstar4atv = widget_button(GUIi,value=eye,event_pro='dstar4atv',xsize=x(20))
endif else label = widget_label(GUIi,value=' ',xsize=x(150))

;******************ROWS E, F, G, H, I****************************
;******************dstar(5) text*****************
if s.nstar gt 5 then begin
   label = widget_label(GUIe,value = '6 ',xsize=x(45),/align_right)
   val_dstar5  = widget_text(GUIe,scr_xsize=x(58),/edit,event_pro='dstar5',$
                             value=strtrim(s.dstar(5),2),/all_events)
   gap = widget_label(GUIe,value = ' ',xsize=x(7))
   dstar5atv = widget_button(GUIe,value=eye,event_pro='dstar5atv',xsize=x(20))
endif else label = widget_label(GUIe,value=' ',xsize=x(137))
;******************dstar(6) text*****************
if s.nstar gt 6 then begin
   label = widget_label(GUIf,value = '7 ',xsize=x(45),/align_right)
   val_dstar6  = widget_text(GUIf,scr_xsize=x(58),/edit,event_pro='dstar6',$
                             value=strtrim(s.dstar(6),2),/all_events)
   gap = widget_label(GUIf,value = ' ',xsize=x(7))
   dstar6atv = widget_button(GUIf,value=eye,event_pro='dstar6atv',xsize=x(20))
endif else label = widget_label(GUIf,value=' ',xsize=x(137))
;******************dstar(7) text*****************
if s.nstar gt 7 then begin
   label = widget_label(GUIg,value = '8 ',xsize=x(45),/align_right)
   val_dstar7  = widget_text(GUIg,scr_xsize=x(58),/edit,event_pro='dstar7',$
                             value=strtrim(s.dstar(7),2),/all_events)
   gap = widget_label(GUIg,value = ' ',xsize=x(7))
   dstar7atv = widget_button(GUIg,value=eye,event_pro='dstar7atv',xsize=x(20))
endif else label = widget_label(GUIg,value=' ',xsize=x(137))
;******************dstar(8) text*****************
if s.nstar gt 8 then begin
   label = widget_label(GUIh,value = '9 ',xsize=x(45),/align_right)
   val_dstar8  = widget_text(GUIh,scr_xsize=x(58),/edit,event_pro='dstar8',$
                             value=strtrim(s.dstar(8),2),/all_events)
   gap = widget_label(GUIh,value = ' ',xsize=x(7))
   dstar8atv = widget_button(GUIh,value=eye,event_pro='dstar8atv',xsize=x(20))
endif else label = widget_label(GUIh,value=' ',xsize=x(137))
;******************dstar(9) text*****************
if s.nstar gt 9 then begin
   label = widget_label(GUIi,value = '10',xsize=x(45),/align_right)
   val_dstar9  = widget_text(GUIi,scr_xsize=x(58),/edit,event_pro='dstar9',$
                             value=strtrim(s.dstar(9),2),/all_events)
   gap = widget_label(GUIi,value = ' ',xsize=x(7))
   dstar9atv = widget_button(GUIi,value=eye,event_pro='dstar9atv',xsize=x(20))
endif else label = widget_label(GUIi,value=' ',xsize=x(137))


;******************ROWS E, F, G, H, I****************************
;Text boxes for offset sky file names - only the specified number (nosky) are displayed
;******************doset(0) text*****************
if s.noset gt 0 then begin
   label = widget_label(GUIe,value = '1 ',xsize=x(52),/align_right)
   val_doset0 = widget_text(GUIe,scr_xsize=x(58),/edit,event_pro='doset0',$
                         value=strtrim(s.doset(0),2),/all_events)
   gap = widget_label(GUIe,value = ' ',xsize=x(7))
   doset0atv = widget_button(GUIe,value=eye,event_pro='doset0atv',xsize=x(20))
endif
;******************doset(1) text*****************
if s.noset gt 1 then begin
   label = widget_label(GUIf,value = '2 ',xsize=x(52),/align_right)
   val_doset1  = widget_text(GUIf,scr_xsize=x(58),/edit,event_pro='doset1',$
                             value=strtrim(s.doset(1),2),/all_events)
   gap = widget_label(GUIf,value = ' ',xsize=x(7))
   doset1atv = widget_button(GUIf,value=eye,event_pro='doset1atv',xsize=x(20))
endif
;******************doset(2) text*****************
if s.noset gt 2 then begin
   label = widget_label(GUIg,value = '3 ',xsize=x(52),/align_right)
   val_doset2  = widget_text(GUIg,scr_xsize=x(58),/edit,event_pro='doset2',$
                             value=strtrim(s.doset(2),2),/all_events)
   gap = widget_label(GUIg,value = ' ',xsize=x(7))
   doset2atv = widget_button(GUIg,value=eye,event_pro='doset2atv',xsize=x(20))
endif
;******************doset(3) text*****************
if s.noset gt 3 then begin
   label = widget_label(GUIh,value = '4 ',xsize=x(52),/align_right)
   val_doset3  = widget_text(GUIh,scr_xsize=x(58),/edit,event_pro='doset3',$
                             value=strtrim(s.doset(3),2),/all_events)
   gap = widget_label(GUIh,value = ' ',xsize=x(7))
   doset3atv = widget_button(GUIh,value=eye,event_pro='d0set3atv',xsize=x(20))
endif
;******************doset(4) text*****************
if s.noset gt 4 then begin
   label = widget_label(GUIi,value = '5 ',xsize=x(52),/align_right)
   val_doset4  = widget_text(GUIi,scr_xsize=x(58),/edit,event_pro='doset4',$
                             value=strtrim(s.doset(4),2),/all_events)
   gap = widget_label(GUIi,value = ' ',xsize=x(7))
   doset4atv = widget_button(GUIi,value=eye,event_pro='doset4atv',xsize=x(20))
endif

;********************ROW K**************************************************
;****************Action buttons**********************************************
GUIk      = widget_base(GUIa,/row)
advanced  = widget_button(GUIk,value=' Advanced',xsize=x(75),event_pro='GUI_adv')
arclines  = widget_button(GUIk,value='Arc lines',xsize=x(75),event_pro='GUI_arc')
closeit   = widget_button(GUIk,value=' Close',xsize=x(75),event_pro='GUI_close')
gap       = widget_label(GUIk,value = ' ',xsize=x(348))
saverb    = widget_button(GUIk,value=' Save RB ',xsize=x(75),event_pro='saveOB')
loadrb    = widget_button(GUIk,value=' Load RB',xsize=x(75),event_pro='loadOB')
autorunrb = widget_button(GUIk,value=' Autorun',xsize=x(75),event_pro='Autorun')
quitgui   = widget_button(GUIk,value=' Quit  ',xsize=x(75),event_pro='GUI_quit')

;*********************Row L, M************************************************
;*********display 3 tables of advanced parameters (if flag3=2)*******************
if s.flag3 eq 2 then begin
;***********set length of table using No  basic parameters (c.flag1)**********
   s.flag4  = fix(s.flag1/3)
   if s.flag1 mod 3 gt 0 then s.flag4 = fix(s.flag1/3) +1 $
         else s.flag4 = fix(s.flag1/3)
;*******copy advanced data into 3 data lists (one for each table)*************
   list1  = strarr(1,s.flag4)
   list2  = strarr(1,s.flag4)
   list3  = strarr(1,s.flag4)
   for i  = 0,s.flag4-1 do  list1(0,i) = strtrim(s.(i),2)
   for i  = 0,s.flag4-1 do list2(0,i) = strtrim(s.(i+s.flag4),2)
   for i  = 0,s.flag1-2*s.flag4-1 do  $
             list3(0,i) = strtrim(s.(i+2*s.flag4),2)
;********copy tag names into 3 name lists (one for each table)****************
   note = 'c.'+strlowcase(tag_names(s))
   note1  = note(0:s.flag4-1)
   note2  = note(s.flag4:2*s.flag4-1)
   note3  = note(2*s.flag4:s.flag1-1)
;*********widgets to display the 3 tables of advanced data********************
   GUIl   = widget_base(GUIa,/row)
   label= widget_label(GUIl,value='ADVANCED SETTINGS')
    gap    = widget_label(GUIl,value = ' ',xsize=x(600))
   label= widget_label(GUIl,value='<CR> to update')
   GUIm   = widget_base(GUIa,/row)
   gap    = widget_label(GUIm,value = ' ',xsize=x(75))
   advance1=widget_table(GUIm,value=list1,row_labels=note1,column_width=x(100),$
                         /no_column_header,/editable,event_pro='table1')
   gap    = widget_label(GUIm,value = ' ',xsize=x(75))
   advance2=widget_table(GUIm,value=list2,row_labels=note2,column_width=x(100),$
                         /no_column_header,/editable,event_pro='table2')
   gap    = widget_label(GUIm,value = ' ',xsize=(75))
   advance3=widget_table(GUIm,value=list3,row_labels=note3,column_width=x(100),$
                         /no_column_header,/editable,event_pro='table3')
endif

;*************************************ROW L, M**********************************
;*********display 2 tables of arcline parameters (if flag3=1)*******************
if s.flag3 eq 1 then begin
   note = 'c.'+strlowcase(tag_names(s))
;*******copy general arcline data into  data list for table 4*******************
   list4  = strarr(1,s.flag2+1)
   list4(0,0) = strtrim(s.narcline,2)
   for i = 0,s.flag2-1 do list4(0,i+1) = strtrim(s.(s.flag1+i),2)
;********copy tag names into list**********************************************
   note4  = strarr(s.flag2+1)
   note4(0) = 'c.narcline'
   note4(1:s.flag2) = note(s.flag1:s.flag1+s.flag2-1)
   for i  = 0,s.flag2-1 do if strpos(note4(i),';') ge 0 then $
       note4(i) = strmid(note4(i),strpos(note4(i),';')+1)
;*******copy calibration line data into 4 column  data list named arc**********
   arc = strarr(4,s.narcline)
   arc(0,*) = strtrim(s.apixc(0:s.narcline-1),2)
   arc(1,*) = strtrim(s.apixw(0:s.narcline-1),2)
   arc(2,*) = strtrim(s.acalwl(0:s.narcline-1),2)
   arc(3,*) = strtrim(s.aflag(0:s.narcline-1),2)
;********set row and column labels**********************************************
   xind = ['Center pixel','+/- pixels','Wavelength','Set(0/1)']
   yind = strtrim(indgen(s.narcline)+1,2)
   width =[x(80),x(60),x(60),x(40)]
;*********widgets to display the 2 tables of arc data***************************
   GUIl   = widget_base(GUIa,/row)
   label = widget_label(GUIl,value='ARC LINES')
   gap   = widget_label(GUIl,value = ' ',xsize=x(600))
   label = widget_label(GUIl,value='<CR> to update')
   GUIm   = widget_base(GUIa,/row)
   gap    = widget_label(GUIm,value = ' ',xsize=x(80))
   arclist = widget_table(GUIm,value=list4,row_labels=note4,column_width=x(80),$
                          scroll=false,/no_column_header,/editable,$
                          event_pro='arclist')
   gap    = widget_label(GUIm,value = ' ',xsize=x(100))
   if s.narcline gt s.flag2 then nline = s.flag2 else nline = s.narcline
   arctable=widget_table(GUIm,value=arc,column_labels=xind,$
                         row_labels=yind,column_width=width,/editable,$
                         event_pro='arctable',scr_ysize=x(20)*(nline+1))
endif
;***************event handler*************************************************
widget_control,GUIa,/realize
widget_control,GUIa,set_uvalue=s
xmanager,'Edit control file',GUIa,/no_block
end

;*************procedure GUI****************************************************
pro gui
;********if a version of GUI is  already running then do not open second*******
if xregistered('Edit control file') ne 0 then return
;*read the active control file (control_data.txt) from the pipeline directory**
read_control,s
;****run procedure GUIa to dispay the graphical user interface*****************
GUIa,s
end


