;************Procedure flat_scale version 1_0******************************
;Procedure  flat_scale,c,fwl,fmag,wl,fscale
;
;Function   Create smoothed profile of the input flat spectrum
;           normalised to its mean value (unit value returned if parameter c.flatscale=0)

;Input:     control data (c), wavelength (fwl) and magnitude (fmag) of intermediate flat spectrum
;           common wavelegth scale (wl)
;Output:    flat spectrum profile (fscale) i.e. smoothed version of flat spectrum
;           normalised to its average value on common wavelength scale
;           unit value returned if parameter c.flatscale=0
;
;Procedures called: None
;
;**************************Procedure**************************************
pro flat_scale,c,fwl,fmag,wl,fscale
;***************creat unit value spectrum on common wavelength base*******
fscale = wl*0.0 + 1.0
;**********return in no flat spectrum profile is required******************
if c.flattype eq 0 then return
;**********create 1 dimensional versions of input spectra and wavelength****
mag = (fltarr(c.ymax/c.ybin)+1.0)*fmag
wll = (fltarr(c.ymax/c.ybin)+1.0)*fwl
;*************Interpolate over masked sections******************************
;********set first and last point of column holding mask data to 1*********
if mag(0) le 0.5 then mag(0) = mean(fmag)
if mag(c.ymax/c.ybin-1) le 0.5 then mag(c.ymax/c.ybin-1) = mean(mag)
;Set arrays to hold  pixel No., magnitude and variance of unmasked points
tempw = fltarr(c.ymax/c.ybin)
temps = fltarr(c.ymax/c.ybin)
;**initialise counter of number of pixels containing unmasked point********
 j=0
;***fill arrays containing pixel No., mag and val for unmasked point******
for m = 0,c.ymax/c.ybin-1 do begin
   tempw(j) = wll(m)
   temps(j) = mag(m)
;***increment counter if original spectra contains unmasked point**********
   if mag(m) gt 0.5 then j = j + 1
endfor
;*truncate arrays of wavelength and magnitude at max No. of unmasked points*
tempw = tempw(0:j-1)
temps = temps(0:j-1)
;*****interpolate data for unmasked points over all wavelength values******
scale=float(SPLINE(tempw,temps,wll,/double))
;******Normalise interpolated flat spectrum to its mean value**************
scale = scale/mean(fmag(where(mag gt 0.5)))
;*******Smooth normalised spectrum to give flat lamp profile***************
;*************degree of smoothing set by parameter c.flatsmth**************
if c.flattype eq 1 then for j=1,c.flatsmth/c.ybin do scale=smooth(scale,j)
;*********transform flat lamp profile onto common wavelength base***********
fscale = SPLINE(wll,scale,wl)
end