;****************procedure file_offset version 1_0*************************
;Procedure	file_offset,c,h,image,offset,output
;
;Function   Creates an offset version of the debiased image in the form
;           required by the optimal extraction process i.e. with the peaks in
;           the lines (traces) on the CCD image at consistent x pixel values.
;           the format of the output array is the same as the offset image
;           the format is described in section 2.1 of the programmers guide
;
;Input:     header data (c,h) and debiased image (image)
;           array containing x pixel values of line centres on CCD as function of y (offset)
;Output:    array (output) containing x values of line centres together with strip images
;           for each line of the debiased image offset to a show peaks at constant x values
;           The output array also contains the median signal level between lines on the CCD.
;
;Procedures called; None
;
;************************Procedure********************************************
pro file_offset,c,h,image,offset,output
;****get number of lines seen on CCD image (from size set for offset array)***
siz    = size(offset)
nline  = siz(1)/(c.lwide/c.xbin+4)
;************set width of strip on CCD image encompassing a line (trace)******
width = (c.lwide/c.xbin)/2
;************set incremental step along output image for each line************
step  = c.lwide/c.xbin + 4
;**set width in x pixels of image averaged to find median signal between lines
nscat = fix(c.lwide/c.xbin/6)
;*******initialise output array (output) and two working arrays***************
output = fltarr(siz(1),siz(2))
line   = intarr(siz(2))
scale  = intarr(siz(2))
;fill output array with offset strip images showing peaks at constant x values
for i = 0,nline-1 do begin
   line  = fix(offset(i*(c.lwide/c.xbin+4),*))
   output(i*(c.lwide/c.xbin+4),*) = offset(i*(c.lwide/c.xbin+4),*)
   for j=0,siz(2)-1 do begin
       output(i*(c.lwide/c.xbin+4)+2:(i+1)*(c.lwide/c.xbin+4)-2,j)=$
                        image(line(j)-width:line(j)+width,j)
   endfor
endfor
;**evaluate median signal between lines (traces) on the CCD image************
for i = 0,nline-1 do begin
   scatlo = total(output((i*step+2):(i*step+nscat+1),*),1)/float(nscat)
   scathi = total(output(((i+1)*step-nscat-1):((i+1)*step-2),*),1)/float(nscat)
;***write median value (over c.yavg/c.ybin pixels) to output array***********
    output(i*(c.lwide/c.xbin+4)+1,*)     = median(scatlo(*),c.yavg/c.ybin)
   output((i+1)*(c.lwide/c.xbin+4)-1,*) = median(scathi(*),c.yavg/c.ybin)
endfor

end

