;*******************procedure circ_make version 1_0**************************
;Procedure	circ_make,c,h,f,image,ypix,peak,num,gapfiber
;
;Function   Count the number of line (traces) on the CCD image (image)
;           Identify the fiber number associated with each line
;           Identify the fiber numbers where the line is lost in
;           the gap between the two haves of the CCD
;
;Input:     median circfile header and image (c,h,f,image)
;Output:    ypix - array of y pixel values used for image cuts
;           peak - array of x-pixel value of line centres for image cuts
;           num  - Number of lines identified in circ image for each cut
;           gapfiber - Array identifying fibers in gap (max of 4)
;
;Report to log	Saving copy of Circ.gif
;Report files	Plot of image profiles showing the fiber number for each line (Circ.gif)
;
;Error   FATAL ERROR: unable to identify peaks correctly in image profile
;message FATAL ERROR: variable number of peaks found in image profile
;
;Procedures called;
;printl       - Prints text message to log file
;
;************************Procedure********************************************
pro circ_make,c,h,f,image,ypix,peak,num,gapfiber
;**************set graphics window********************************************
!P.MULTI =[0,1,c.circlev,0,0]
window,xsize=c.psize,ysize=fix(0.7*c.psize)    &    !P.CHARSIZE=1.5
;******set up plot and output arrays******************************************
siz    = size(image)
peak   = fltarr(c.nfiber,c.circlev)
num    = intarr(c.circlev)
yplot  = fltarr(c.circlev,siz(1))
;******set y-pixel value for intermediate cuts*********************************
ypix   = indgen(c.circlev)*c.ymax/c.ybin/(c.circlev-1)
;******set y-pixel value for upper and lower cuts******************************
ypix(0)= c.yavg/c.ybin
ypix(c.circlev-1) =  c.ymax/c.ybin
;******create and analyse a smoothed profile at each cut level*****************
for k = 0,c.circlev-1 do begin
   indup = fltarr(c.nfiber)
   inddn = fltarr(c.nfiber)
   k_up = 0   &   k_dn = 0
;************Select a strip accross the CCD image several y-pixels wide********
   y=image(*,ypix(c.circlev-1-k)-c.yavg/c.ybin:ypix(c.circlev-1-k)-1)
;*********average and smooth this strip to give a line profile (y)*************
   y = smooth(median(y,dimension=2),c.circsmth/c.xbin)
   scale  = mean(y)
   scale = mean(y)
;*********Remove the low frequency component of the line profile***************
   an = svdfit(indgen(n_elements(y)),y,2,yfit=lowy)
   y = y - lowy - c.circzero*scale
;*********Normalise profile to its mean value**********************************
   yplot(k,*) = y/scale
;***********************plot current image profile*****************************
   plot,yplot(k,*),background=c.white,color=c.black,ytickinterval=2,yminor=1,xstyle=1,$
     yticklen =0.003,ytitle = 'y='+strtrim(ypix(c.circlev-1-k)-ypix(0)/2,2)
   oplot,y*0.0,color=c.black
;**********Fill array holding positive zero crossing values ******************
   for j = 1,n_elements(y)-1 do begin
      if ((y(j-1) lt 0) and (y(j) ge 0)) then begin
         indup(k_up) = j- (y(j))/float(y(j)-y(j-1))
         k_up = k_up + 1   &     j=j+10/c.xbin
      endif
   endfor
;**********Fill array holding negative zero crossing values ******************
   for j = 1,n_elements(y)-1 do begin
      if ((y(j-1) ge 0) and (y(j) lt 0)) then begin
         inddn(k_dn) = j - (y(j))/float(y(j)-y(j-1))
         k_dn = k_dn + 1     &      j=j+10/c.xbin
      endif
   endfor
;******Check equal numbers of positive and negative crossings are detected****
   if k_up ne k_dn then printl,c.log,$
       'FATAL ERROR: unable to identify peaks correctly in image profile'
   if k_up ne k_dn then stop
;**Use +ve and -ve crossing values to fil array of x-pixel positions of peaks*
   num(c.circlev-k-1) = k_up
   peak(*,c.circlev-k-1) =0.5*indup(*)+0.5*inddn(*)
;***********print number of lines identified in current cut*******************
   print,strtrim(k_up,2)+'/'+strtrim(k_dn,2)+$
   ' lines identified at y = '+ strtrim(ypix(c.circlev-1-k)-c.yavg/c.ybin/2,2)
endfor
;************check same number of lines found for each cut*********************
nline = num(0)
index = where(num ne nline,count)
if count gt 0 then printl,c.log,$
'FATAL ERROR: variable number of peaks found in image profile'
if count gt 0 then stop
;***************count no. lines on each side of gap***************************
index=where(peak(0:nline-1,c.circlev/2) lt c.oscan2/c.xbin-1,nlhs)
index=where(peak(0:nline-1,c.circlev/2) gt c.oscan3/c.xbin-1,nrhs)
print,'with '+strtrim(nlhs,2)+' peaks on LHS  and '+strtrim(nrhs,2)+' on RHS'
;************************set array of all valid fibers ***********************
;******f.stat type 1 is a valid fiber & type 4 is a valid fiber but in gap****
;******f.type X is a fiber with invalid or parked target (i.e. no trace)******
fvalid = fix(f.stat)
fvalid(where (f.stat eq '1' or f.stat eq '4')) = 4
fvalid(where (f.type eq 'X')) = 0
;************identify fibers showing lines on rhs (i.e. not in gap)************
j = 1
for i = 1,c.nfiber do if f(c.nfiber-i).stat eq '1' and j le nlhs $
  and f(c.nfiber-i).type ne 'X'then begin
   fvalid(c.nfiber-i) = 1
   j = j + 1
endif
;*************identify fibers showing lines on lhs (i.e. not in gap**************
j = 1
for i = 0,c.nfiber-1 do if f(i).stat eq '1' and j le nrhs $
  and f(i).type ne 'X' then begin
   j = j + 1
   fvalid(i) = 1
endif
;************capture fiber numbers of fibers in gap (maximum 4)******************
gapfiber = intarr(4)
j = 0
for i = 0,c.nfiber-1 do if fvalid(i) eq 4 and f(i).type ne 'X' then begin
   gapfiber(j) = i+1
   f(gapfiber(j)-1).stat='4'
   j = j + 1
endif
;*************identify fiber numbers of lines (traces) on CCD image**************
f(*).line = 0
j = nline
for i = 0,c.nfiber-1 do if fvalid(i) eq 1 and f(i).type ne 'X' then begin
   f(i).line = j
   j = j - 1
endif
;*create array of fiber numbers corresponding to lines left to right across image*
fiber = intarr(nline)
j = 0
for i = 1,c.nfiber do if fvalid(c.nfiber-i) eq 1 then begin
   fiber(j) = c.nfiber-i+1
   j= j + 1
endif
;*************replot image profile with text indicating fiber number of each line*
for k = 0,c.circlev-1 do begin
   plot,yplot(k,*),background=c.white,color=c.black,ytickinterval=2,yminor=1,xstyle=1,$
     ytitle = 'y='+strtrim(ypix(c.circlev-1-k)-ypix(0)/2,2),yrange=[-2,8]
   oplot,yplot(k,*)*0.0,color=c.black
;**************add fiber numbers to plot of mid y profile*************************
   if k eq (c.circlev/2) then for i = 0,num(0)-1 do begin
      xx = peak(i,c.circlev-k-1)+siz(1)/500.
      yy = (i-fix(i/2)*2)*5-0.5
      XYOUTS,xx,yy,fiber(i),charsize=0.7,orientation=90,color=c.black
   endfor
endfor
;*******************************Save plot to log file******************************
WRITE_gif,c.pdir+c.plog+'Circ.gif',TVRD()
printl,c.log,'Saving copy of Circ.gif'
!p.multi = 0
end
