;********************Procedure arc_gui version 1_0***************************
;procedure arc_gui,c
;Function  This procedure provides the graphical user interface for procedure Atlas
;          to edit parameters of the control data relating to arc line calibration
;          It is not a standalone procedure, it is called by the parent procedure Atlas,
;          which also controls the graphics associated the editing process
;          Control data may be saved to the current control file
;          It can also overwrite the source control file in the project directory
;
;Message to log:Overwriting arcline data for control file xxx (if actioned)
;
;**set of procedures relating to graphical user interface GUI.pro****
;
;*********Local procedures used to control mouse functions*********************
;********these  are used to identify lines on plots of  arc/atlas spectra******
;*******and to return the pixel position/wavelength at the cursor location*****
;
;procedure get_yoff,s
;Function  read the pixel position of a cursor on a plot of overlayed arc spectra
;          to identify the y pixel position line to be used to estimate the y
;          offset of spectra (parameter s.arcrefc in te control data)
;
;Input     control data (s)
;Output    control data with parameter s.arcrefc updated
;
pro get_yoff,s
;***********write message on plot area******************************************
XYOUTS,fix(s.ymax/2.5/s.ybin),1.6*float(s.ccdzero)/float(s.arcscale),$
  'Click on line to use for offset',color=s.red
;*****************read x,y value of mouse co-ordinates on plot scale************
!mouse.button = 0
while (!mouse.button ne 1) do  cursor, xval,yval
;**********if x value is in range then update parameter s.arcrefc***************
if xval gt s.atl(3) and xval lt s.ymax/s.ybin-s.atl(3) then s.arcrefc=fix(xval)
end

;procedure get_pix,s
;Function  read the pixel position of a cursor on a plot of overlayed arc spectra
;          to identify the y pixel position line of an arcline selected for calibration
;          the centre positions of these arclines are stored in array s.apixc(#)
;          whre # is the row counter in the arcline table (parameter c.atlaline)
;
;Input     control data (s)
;Output    control data with parameter s.apixc(#) updated
;
pro get_pix,s
;***********write message on plot area******************************************
XYOUTS,s.atl(0)+0.4*(s.atl(1)-s.atl(0)),s.atl(2)*2.1,$
  'Click on line to get pixel',color=s.red
;******If the number of atlas lines is less than the row counter then return*******
if s.natl lt s.atlaline+1 then return
;*****************read x,y value of mouse co-ordinates on plot scale. Note the *****
;plotscale refers to the last plot displayed i.e. the wavelength scale of the atlas plot
!mouse.button = 0
while (!mouse.button ne 1) do cursor, xval,yval
;**********if x value out of range then return************************************
if xval lt s.wlmin or xval gt s.wlmax  or yval lt s.atl(2) then return
;*****calculate the equivalent pixel number from the reported wavelength values***
;****set control parameter s.apixc(#) to the measured pixel number****************
pxmin =-s.atl(3)-fix(0.1*s.ymax/s.ybin)
pxmax =fix(1.1*s.ymax/s.ybin)
s.apixc(s.atlaline) = pxmin + (pxmax-pxmin)*$
       (xval-s.atl(0))/(s.atl(1)-s.atl(0))
end

;procedure get_wl,s
;Function  read the wavelength position of a cursor on a plot of atlas lines
;          to identify the wavelength of an arcline selected for calibration
;          the wavelengths these arclines are stored in array s.acalwl(#)
;          where # is the row counter in the arcline table (parameter c.atlaline)
;
;Input     control data (s)
;Output    control data with parameter s.acalwl(#) updated
;
pro get_wl,s
;***********write message on plot area******************************************
XYOUTS,s.atl(0)+0.4*(s.atl(1)-s.atl(0)),s.atl(2)*0.8,$
  'Click on line get wavelength',color=s.red
;******If the number of atlas lines is less than the row counter then return*******
if s.natl lt s.atlaline+1 then return
;*****************read x,y value of mouse co-ordinates on plot scale*************
!mouse.button = 0
while (!mouse.button ne 1) do cursor, xval,yval
;**********if x value out of range then return************************************
if xval lt s.wlmin or xval gt s.wlmax  or yval lt 0 $
    or yval gt s.atl(2) then return
;****get index of line in array of atlas line wavelengths closest to cursor vale
delta = min(abs(s.atlwl(0:s.natl-1)-xval),min_index)
;****set control parameter s.acalwl(#) to the corresponding wavelength*************
s.acalwl(s.atlaline) = s.atlwl(min_index)
end

;***************Button event procedures*******************************************
;***Arcline data is edited in a 3 stage process**********************************
;the sequence is controlled by parameter s.atlflag which takes values 0,1,2 *******

;****Edit pixel number of arcline used to calculate y offsets***********************
pro arcrefc,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;**************return if not at step 0 of editing process*************************
if s.atlflag ne 0 then return
s.arcrefc = fix(dummy)
write_control,s
widget_control,event.top,/destroy
end

;****Edit pixel range bracketing  arcline used to calculate y offsets******************
pro arcrefw,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;**************return if not at step 0 of editing process*************************
if s.atlflag ne 0 then return
s.arcrefw = fix(dummy)
write_control,s
widget_control,event.top,/destroy
end

;****Use cursor to read new pixel number of arcline used to calculate y offsets***
pro select_yoff,event
widget_control,event.top,get_uvalue=s
;**************return if not at step 0 of editing process*************************
if s.atlflag ne 0 then return
get_yoff,s
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;***edit parameter controlling the y axis scale on plots of arc spectra***********
pro arcscale,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;*******************return if beyond 1 of editing process*************************
if s.atlflag gt  1 then return
s.arcscale=fix(dummy)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;**************Move to step 2 of editing process by setting S.atlflag=1***********
pro acceptoffset,event
widget_control,event.top,get_uvalue=s
;**************return if not at step 0 of editing process*************************
if s.atlflag ne 0 then return
s.atlflag = 1
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;**************edit minimum wavelength of common wavelength scale*******************
pro arc_wlmin,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.wlmin = fix(dummy)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;**************edit maximum wavelength of common wavelength scale*******************
pro arc_wlmax,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.wlmax =fix(dummy)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;************set the maximum amd minimum wavelength values to zero****************
;***this caused new values to be calculated from header data parameters **********
;*****the next time procedure arc_atlas is run by the parent procedure Atlas*****
pro arc_wlzero,event
widget_control,event.top,get_uvalue=s
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.wlmin =0.0
s.wlmax =0.0
print,'Resetting maximum and minimum wavelengths'
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;*****Edit the number of calibration lines displayed in the arcline table********
pro narcline,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
lineo = s.narcline
s.narcline=fix(dummy)
;*zero elements of arcline data above new table length (if new less than old)
if s.narcline lt lineo then begin
   s.apixc(s.narcline:lineo-1)  = 0L
   s.apixw(s.narcline:lineo-1)  = 0L
   s.acalwl(s.narcline:lineo-1) = 0L
   s.aflag(s.narcline:lineo-1)  = 0
endif
;*fill elements of arcline data arrays up to new table length (if new > old)
if s.narcline gt lineo then begin
   s.apixc(lineo:s.narcline-1)  = s.apixc(lineo-1)
   s.apixw(lineo:s.narcline-1)  = s.apixw(lineo-1)
   s.acalwl(lineo:s.narcline-1) = s.acalwl(lineo-1)
   s.aflag(lineo:s.narcline-1)  = 1
endif
write_control,s
;******write control data to file return to parent procedure to update GUI*****
widget_control,event.top,/destroy
end

;***************Edit name of Atlas file*****************************************
pro arc_atlfile,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.atlfile=strtrim(dummy,2)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;***edit parameter controlling the y axis scale on plot of atlas data***********
pro atlscale,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.atlscale=fix(dummy)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;***edit number of calibration lines displayed on plot atlas data***********
pro natlas,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.natl = fix(dummy)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;**********Text editing of items in table of arc line data**************
pro arcline,event
widget_control,event.top,get_uvalue=s
widget_control,event.id,get_value=dummy
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.apixc(0:s.narcline-1)  = dummy(0,0:s.narcline-1)
s.apixw(0:s.narcline-1)  = dummy(1,0:s.narcline-1)
s.acalwl(0:s.narcline-1) = dummy(2,0:s.narcline-1)
s.aflag(0:s.narcline-1)  = dummy(3,0:s.narcline-1)
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;****Edit  parameter (s.atlaline) specifying  row of the arcline table is**
;****edited when cursor is used to select new pixel position or wavelength data
pro ncalline,event
widget_control,event.top,get_uvalue=s
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
if s.atlflag gt 1 then  s.atlflag=1
s.atlaline=event.index
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;*****Edit pixel position of current arcline in table of arcline data using cursor*****
pro select_px,event
widget_control,event.top,get_uvalue=s
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
;*************if at step 1 then call procedure get_pix*********************
;Input     control data (s)
;Output    control data with parameter s.apixc(#) updated
if s.atlflag eq 1 then get_pix,s else s.atlflag=1
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;*****Edit wavelength  of current arcline in table of arcline data using cursor*****
pro select_wl,event
widget_control,event.top,get_uvalue=s
;******return if at step 0 or reset to step 1 (if at a later stage of process)*****
if s.atlflag eq 0 then return
;*************if at step 1 then call procedure get_wl*********************
;Input     control data (s)
;Output    control data with parameter s.acalwl(#) updated
if s.atlflag eq 1 then get_wl,s else s.atlflag=1
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;**Run the wavelength calibration process using the current arcline control data
pro viewcal,event
widget_control,event.top,get_uvalue=s
;*************if at step 0 then return****************************************
if s.atlflag eq 0 then return
;*******if at step 1 then set flag to step 2**********************************
if s.atlflag eq 1 then s.atlflag=2
;******write control data to file return to parent procedure to refresh plot*****
write_control,s
widget_control,event.top,/destroy
end

;****Quit areline editing process cancelling all changes to control file data
pro quitarc,event
widget_control,event.top,get_uvalue=s
s.atlflag=9
;******write control data to file return to parent procedure to quit**********
;****atlflag=9 causes Altas to reset the control data cancelling all changes*
write_control,s
widget_control,event.top,/destroy
end

;Overwrite the source control file in the project directory with current data
pro savecal,event
widget_control,event.top,get_uvalue=s
if s.atlflag ne 2 then return
file = s.pdir+s.rbname+'.txt'
printl,s.log,'Overwriting arcline data for control file '+file
;******write control data to the  source control file in the project directory***
write_control,s,FILE=file
end

;*****Finish editing process*********************************
pro acceptcal,event
widget_control,event.top,get_uvalue=s
;****************check at right stage to finish**********
if s.atlflag ne 2 then return
s.atlflag=3
;******write control data to file return to parent procedure with altflag set to 3*****
write_control,s
widget_control,event.top,/destroy
end

;********************Parent procedure******************************
pro arc_gui,c
;*********copy control data to structure s************************
s = c
;**********set array controlling pixel sizing of GUI*************
x = fix(s.csize*indgen(1000))
;**************set parameters for table of arcline data********
xind = ['Center pixel','+/- pixels','Wavelength','Set']
yind = strtrim(indgen(s.narcline)+1,2)
width =[x(64),x(55),x(75),x(30)]
arc = strarr(4,s.narcline)
arc(0,*) = strtrim(s.apixc(0:s.narcline-1),2)
arc(1,*) = strtrim(s.apixw(0:s.narcline-1),2)
arc(2,*) = strtrim(s.acalwl(0:s.narcline-1),2)
arc(3,*) = strtrim(s.aflag(0:s.narcline-1),2)
;*******************Widget base*************************************
GUAa   = widget_base(title = 'Edit arcline data',/column)
;*****************ROW A title for stage 1**************************
label = widget_label(GUAa,/align_left,value = $
    'SELECT ARCLINE USED TO FIND Y-OFFSET',xsize=x(300))
;****************ROW B Arcline for yoffset **************************
;********open data for editing if atlflag=0*************************
if s.atlflag eq 0 then sense=1 else sense=0
;*********Line centre text***************************************
GUAb  = widget_base(GUAa,/row)
label  = widget_label(GUAb,value = 'Line centred at ',xsize=x(80),/align_left)
val_arcrefc  = widget_text(GUAb,scr_xsize=x(45),/edit,event_pro='arcrefc',$
                          /align_center,/sensitive,value=strtrim(s.arcrefc,2))
widget_control,val_arcrefc,sensitive=sense
;*********width of markers  text*************************************
label  = widget_label(GUAb,value = ' +/- ',xsize=x(35),/align_center)
val_arcrefw  = widget_text(GUAb,scr_xsize=x(30),/edit,event_pro='arcrefw',$
                          /align_center,/sensitive,value=strtrim(s.arcrefw,2))
widget_control,val_arcrefw,sensitive=sense
;***********select line centre from plot using mouse****************
label  = widget_label(GUAb,value = '  pixels',xsize=x(54),/align_left)
button1 = widget_button(GUAb,value='Select',event_pro='select_yoff',xsize=x(60),$
                        /sensitive)
widget_control,button1,sensitive=sense

;************ROW C Plotscale and accept offset **********************
GUAc  = widget_base(GUAa,/row)
;**********************Arc plot scaling text****************************
label  = widget_label(GUAc,value = 'Arc plot scaling',xsize=x(91),/align_left)
val_arcscale   = widget_text(GUAc,scr_xsize=x(35),/edit,event_pro='arcscale',$
                             /align_center,value=strtrim(s.arcscale,2))
gap     = widget_label(GUAc,value =' ',xsize =x(30))
label   = widget_label(GUAc,value ='<CR> to enter',xsize=x(90),/align_left)
;**********Accept stage 1 data text*****************************
button2 = widget_button(GUAc,value='Accept',event_pro='acceptoffset',$
                        xsize=x(60),sensitive=sense)
widget_control,button2,sensitive=sense

;******Row D set wavelength range ***********************************
;********open data for editing if atlflag>0******************
gap = widget_label(GUAa,value=' ')
label7 = widget_label(GUAa,/align_left,value = $
    'SELECT ATLAS AND WAVELENGTH RANGE')
GUAd  = widget_base(GUAa,/row)
label9  = widget_label(GUAd,value = 'Wavelength',xsize=x(68),/align_left)
;*************lower limit of wavelength text**************************
val_awlmin = widget_text(GUAd,scr_xsize=x(55),/edit,event_pro='arc_wlmin',/sensitive,$
                      /align_center,value=string(s.wlmin,format='(F9.2)'))
widget_control,val_awlmin,sensitive=s.atlflag
label  = widget_label(GUAd,value = 'to',/align_center,xsize=x(36))
;*************upper limit of wavelength text**************************
val_awlmax  = widget_text(GUAd,scr_xsize=x(55),/edit,event_pro='arc_wlmax',/sensitive,$
                      /align_center,value=string(s.wlmax,format='(F9.2)'))
widget_control,val_awlmax,sensitive=s.atlflag
label  = widget_label(GUAd,value = 'A',/align_center,xsize=x(26))
;*********zero wavelengths so that parent procedure calculates limits from header data
button3 = widget_button(GUAd,value='Reset',event_pro='arc_wlzero',xsize=x(60),/sensitive)
widget_control,button3,sensitive=s.atlflag

;*******************Row E  Arcline settings **************************
;********open data for editing if atlflag>0******************
GUAe  = widget_base(GUAa,/row)
label  = widget_label(GUAe,value = 'Atlas name',xsize=x(60),/align_left)
;******atlas file name text**********************************************
val_atlas  = widget_text(GUAe,scr_xsize=x(100),/edit,event_pro='arc_atlfile',$
                      /align_center,/sensitive,value=s.atlfile)
widget_control,val_atlas,sensitive=s.atlflag
;*atlas plot scaling text*********************************************
label  = widget_label(GUAe,value = 'Atlas plot scaling',xsize=x(114),/align_right)
val_atlscale  = widget_text(GUAe,scr_xsize=x(28),/edit,event_pro='atlscale',$
                /align_center,/sensitive,value=strtrim(s.atlscale,2))
widget_control,val_atlscale,sensitive=s.atlflag

;********************Row F Atlas settings*****************************
;********open data for editing if atlflag>0******************
GUAf  = widget_base(GUAa,/row)
;****************number of arclines text***********************************
label  = widget_label(GUAf,value = 'Number of arclines',xsize=x(109),/align_left)
val_narcline = widget_text(GUAf,scr_xsize=x(28),event_pro='narcline',/align_center,$
                           /edit,/sensitive,value=strtrim(s.narcline,2))
widget_control,val_narcline,sensitive=s.atlflag
;****************number of atlas lines text***********************************
label  = widget_label(GUAf,value = 'Number of atlas lines',xsize=x(135),/align_right)
val_natlas = widget_text(GUAf,scr_xsize=x(28),/edit,event_pro='natlas',$
                         /align_center,/sensitive,value=strtrim(s.natl,2))
widget_control,val_natlas,sensitive=s.atlflag

;************Edit data in arc  line table*********************************
;********open data for editing if atlflag>0******************
gap = widget_label(GUAa,value=' ')
label = widget_label(GUAa,/align_left,xsize=x(300),$
                     value = 'SELECT ARCLINES FOR CALIBRATION')

;********************Row G Table of arclines***************************
GUAg   = widget_base(GUAa,/row)
;*********text editing of te arcline data table*************************
table1 = widget_table(GUAg,value=arc,column_labels=xind,/editable,$
         row_labels=yind,column_width=width,event_pro='arcline',/sensitive)
widget_control,table1,sensitive=s.atlflag

;***************Row H Action buttons to edit accept arcline data********************
GUAh    = widget_base(GUAa,/row)
label = widget_label(GUAh,value = 'Set line',xsize=x(43),/align_left)
nline = ' '+strtrim(indgen(s.narcline)+1,2)+' '
;**********select row number to edit droplist ************************
drop1  = widget_droplist(GUAh,value = nline,event_pro='ncalline',xsize=x(40),/sensitive)
widget_control,drop1,sensitive=s.atlflag
widget_control,drop1,set_droplist_select=s.atlaline
;***********select line centre from arc spectra plot using mouse *******
button4 = widget_button(GUAh,value='Pixel No.',event_pro='select_px',xsize=x(75),/sensitive)
widget_control,button4,sensitive=s.atlflag
;***********select line wavelength from atlas plot using mouse****************
button5 = widget_button(GUAh,value='Wavelength',event_pro='select_wl',xsize=x(75),/sensitive)
widget_control,button5,sensitive=s.atlflag
gap     = widget_label(GUAh,value = ' ',xsize=x(10))
;**********view wavelength solution using current data button********************
button6 = widget_button(GUAh,value='View',event_pro='viewcal',xsize=x(60),/sensitive)
widget_control,button6,sensitive=s.atlflag
;*****************Section 4 Accept arcline data**********************************
gap = widget_label(GUAa,value=' ')
label = widget_label(GUAa,/align_left,value = $
                     'ACCEPT CALIBRATION / OVERWRITE SOURCE FILE')
;****************Row I Complete calibration *****************************
GUAi  = widget_base(GUAa,/row)
;********open buttons for editing if atlflag=2****************************
if s.atlflag eq 2 then sense=1 else sense=0
;*****************quit button*******************************************
button7 = widget_button(GUAi,value='Quit',event_pro='quitarc',xsize=x(60))
gap      = widget_label(GUAi,value =' ',xsize=x(126))
;*****************overwrite control data in project directory button*******
button8 = widget_button(GUAi,value='Overwrite',event_pro='savecal',xsize=x(60),/sensitive)
widget_control,button8,sensitive=sense
;*****************overwrite current control data file button*******
button9 = widget_button(GUAi,value='Accept',event_pro='acceptcal',xsize=x(60),/sensitive)
widget_control,button9,sensitive=sense

;***************event handler*************************************************
;*********xmanager blocks command line entry until gui closed***********************
widget_control,GUAa,/realize
widget_control,GUAa,set_uvalue=s
xmanager,'Edit arc lines',GUAa
end