;**********************Procedure arc_cal version 1_0********************
;Procedure  arc_cal,c,h,f,spectra,yoff,del,wlmin,wlmax
;
;Function   For each fiber fit a polynomial of wavelength vs pixel number
;           using the header table of pixel range and  wavelengths for selected arclines
;           use polymonial to fill the wavelength per pixel in the intermediate arc spectra
;
;Input:    arcfile header and intermediate arc spectra (c,h,f,spectra)
;           yoff - relative offset of individual arc spectra
;Output:    wavelength calibration added data array of arc spectra (spectra)
;           using polynomial fit of wavelength vs pixel number
;           array of offsets between calibration data and polynomial fits (del)
;           limits of common wavelegth range found from spectra (wlmin,wlmax)
;
;Error     FATAL ERROR insufficient arclines flagged for spectified order of fit
;message
;
;Procedures called;
;printl       - Prints text message to log file
;
;******************Procedure********************************************
pro arc_cal,c,h,f,spectra,yoff,del,wlmin,wlmax
;**********check number of arclines flagged is OK***********************
index = where(c.aflag gt 0,nset)
if nset lt c.arcorder + 1 then printl,c.log,$
'FATAL ERROR insufficient arclines flagged for spectified order of fit'
if nset lt c.arcorder + 1 then stop
;***********set up arrays used in calculation***************************
ospec = dblarr(c.nfiber,c.ymax/c.ybin)
;array yval holds the centerline of each calibration line for each fiber
yval  = dblarr(c.nfiber,c.narcline)
ind   = indgen(c.ymax/c.ybin,/double)
delta = dblarr(c.nfiber)
del= fltarr(c.nfiber,nset)
;*********set y axis range for plots************************************
yscale = 2*float(c.ccdzero)*(c.lwide-4)/4.0
if c.arcscale gt 1 then yscale = yscale/float(c.arcscale)
;*****************shift spectra by y offset*****************************
specoff = fltarr(c.nfiber,c.ymax/c.ybin+max(yoff))
pixel   = indgen(c.ymax/c.ybin+max(yoff))-max(yoff)
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then $
  specoff(i,max(yoff)-yoff(i):max(yoff)-yoff(i)+c.ymax/c.ybin-1)=$
            spectra(8*(f(i).line-1)+5,*)
;******************plot overlay of offset spectra***********************
;****************lines indicating central range of plot*****************
mark = float(pixel*0)
mark(where(pixel lt 0 or pixel gt (c.ymax/c.ybin-max(yoff)))) = yscale
;***********Plot axes for overlay of arc spectra************************
plot,pixel,mark,background=c.white,color=c.black,xstyle=1$
     ,title='Overlay of offset spectra using reference line'$
     ,ytitle='e-/pixel',yrange=[0,yscale],ystyle=1,linestyle=1
;***add line markers bracketing arc lines used for calibration*********
mark = fltarr(c.ymax/c.ybin+max(yoff))
for i = 0,c.narcline-1 do if c.apixc(i)-c.apixw(i) gt 1 and $
   c.apixc(i)+c.apixw(i)+2 lt c.ymax+max(yoff) and c.aflag(i) eq 1 then begin
   mark(c.apixc(i)-c.apixw(i)-1:c.apixc(i)-c.apixw(i)+1) = yscale/2
   mark(c.apixc(i)+c.apixw(i)-1:c.apixc(i)+c.apixw(i)+1) = yscale/2
endif
oplot,indgen(c.ymax+max(yoff)),mark,color=c.red
;*******************plot arc spectra***********************************
for i = 0,c.nfiber-1 do  oplot,pixel,specoff(i,*),color=c.black
;********************Get position of calibration lines*****************
;by fitting a Gaussian profile to sections of the spectra bracketing each line
;*************set array of pixels used for Gaussian fit***************
xpix = indgen(2*fix(c.arcwide/2)+1)-c.arcwide/2-(c.arcwide mod 2)
;**************set axes for plot showing overlay of peak profiles*****
plot,xpix,xpix*0,yrange=[0,1],background=c.white,xstyle=1,$
     title = 'Overlay of calibration line profiles for file '+$
       strtrim(c.arcfile,2),ytitle='normalized',color=c.black
;**************loop for all valid fiber numbers**************************
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then begin
;**********select offset spectra as 1D array****************************
    ospec(i,0:c.ymax/c.ybin-max(yoff)-1)=$
      spectra(8*f(i).line-8+5,yoff(i):c.ymax/c.ybin+yoff(i)-max(yoff)-1)
;**********loop for each calibration line********************************
   for j = 0,c.narcline-1 do if c.aflag(j) eq 1 then begin
;**find position of peak in arc spectra corresponding to calbration line*
      maxl =max(ospec(i,c.apixc(j)-c.apixw(j):c.apixc(j)+c.apixw(j)),max_subscript)
      ymax = max_subscript  + c.apixc(j)-c.apixw(j)
;***********plot section of arc spectra used to identify the peak********
      x = ind((ymax-c.arcwide):(ymax+c.arcwide))
      y = double(ospec(i,(ymax-c.arcwide):(ymax+c.arcwide)))
      oplot,xpix,y(c.arcwide/2:3*c.arcwide/2)/max(y),color=c.red
;*fit Gaussian to get best fit to line centre using IDL procedure GAUSSFIT
;this gives message: Program caused arithmetic error: Floating underflow
;**this message is OK in this context and does not indicate an error*****
      res = gaussfit(x,y,coeff,NTERMS = 4)
      A=coeff
      peak = A(0)*exp(-(x-A(1))*(x-A(1))/(A(2)*A(2)*2))+A(3)
;********save centreline data in array yval*******************************
      yval(i,j) = coeff(1)+yoff(i)
   endif
endif
;********select flagged arclines to used for polynomial fit*************
yvalf = dblarr(c.nfiber,nset)
refwl = dblarr(nset)
refpx = dblarr(nset)
j = 0
for i = 0,c.narcline-1 do if c.aflag(i) eq 1 then begin
   refwl(j) = c.acalwl(i)
   yvalf(*,j) = yval(*,i)
   j = j + 1
endif
;***********fit a polynomial function to line centre data for each fiber***
;**********and use result to get the wavelength value for each pixel*******
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X'  then begin
   refpx(*) = yvalf(i,*)
   A = SVDFIT(refpx,refwl,c.arcorder,/double,yfit=YFIT)
   wlest = float(poly(ind,A))
;****save value of delta between polynomial fit and actual line centre*****
   del(i,*) = (yfit-refwl)
;save the wavelength value for each pixel in the intermediate spectra array
   spectra(8*(f(i).line-1),*) = float(poly(ind,A))
endif
;*********Get maximum common wavelength range******************************
wllo = strarr(c.nfiber)
wlhi = strarr(c.nfiber)
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then begin
   wllo(i) = spectra(f(i).line*8-8,0)
   wlhi(i) = spectra(f(i).line*8-8,c.ymax/c.ybin-1)
endif
wlmin = (10*long(max(wllo(where(wllo gt 0)))))/10.0+0.1
wlmax = (10*long(min(wlhi(where(wlhi gt 0)))))/10.0-0.1
;********* set up plot showing overlay of wavelength calibrated spectra****
tit = 'Common wavelength '+string(wlmin,format='(f8.1)')$
   + ' to '+string(wlmax,format='(f8.1)')+' A'+$
   '   max delta of fit:'+string(max(abs(del)),format='(f6.3)')+' pixel'
plot, spectra(0,*),spectra(0,*)*0,background=c.white,color=c.black,xstyle=1,$
       yrange=[0,yscale],ystyle=1,xrange=[c.wlmin,c.wlmax],$
      xtitle = 'Wavelength (A)',ytitle='e-/pixel',title = tit
;***plot markers  showing arclines used for calibration********************
for i = 0,nset-1 do oplot,[refwl(i),refwl(i)],[0,yscale],color=c.black,linestyle=1
;*********************plot calibrated spectra******************************
siz = size(spectra)
for i = 0,siz(1)/(c.lwide/c.xbin+4)-1 do if f(i).line gt 0 and $
  f(i).type ne 'X' then  oplot,spectra(8*i,*),spectra(8*i+1,*),color=c.black
;*********annotate plot wit values of rms fit for each calibration line****
index = where(f.type ne 'X' and f.line gt 0,nfiber)
rmsdel =  sqrt(total(del*del,1)/float(nfiber))
for i = 0,nset-1 do  XYOUTS,refwl(i)+0.015*(c.wlmax-c.wlmin),0.3*yscale,$
orientation=90,string(rmsdel(i),format='(f6.3)'),color=c.black,charsize=0.8
end
