;*********************Procedure Arc version 1_0***********************
;Procedure	Arc
;Function 	Check input file type, binning and fiber allocations are correct
;         	Create intermediate file of optimally extracted spectra
;        	Calibrate wavelength against pixel position for active fibers
;
;Options	   Arc,/NOEXTRACT - skips optimal extraction stage
;        	Arc,/ATLAS - runs procedure Atlas to create/edit arcline data
;
;Input      Raw data image(s) of the arc lamp (r1234567.fit)
;Output   	Arcfile containing extracted arc spectra & wavelength per pixel (a1234567.fit)
;
;Report to log	RUNNING PROCEDURE:Arc
;              For file number 1234567
;           	New Arc file created:a1234567
;              Lamp Ne  max delta for fit  0.### pixels (see file arc.txt)
;              Common wavelength range  ####.#  to   #####.# A
;              Arcline  wavelength  mean_delta_fit  rms_delta_fit
;              1     ####.###       #.###        #.### (repeat for each arcline)
;
;Report files	Image of five  plots showing stages of the calibration process (Arc.gif)
;              Table of wavelength limits and deviation of calibration lines per fiber (Arc.txt)

;Error 	FATAL ERROR: incorrect file type, file type is xxx
;message ERROR: specified minimum wavelength greater than actual maximum
;        ERROR: specified maximum wavelength greater than actual maximum
;
;Procedures called;
;read_control - Returns control data in structure c
;read_data    - Reads pipeline header (c,h,f) and binary image of raw data file
;read_file    - Reads pipeline header (c,h,f) and image of pipeline fits file
;extr_file    - Optimal extract target spectra to produced intermediate spectra
;atlas        - Run GUI to edit arcline data in control file
;arc_offset   - Get relative offset of individual arc spectra in pixels
;arc_cal      - Add wavelength calibration to data array of arc spectra
;write_file   - Writes pipeline header (c,h,f) and data array to fits file
;printl       - Prints text message to log file
;
;*****************Procedure*******************************************
pro Arc,atlas=ATLAS,noextract=NOEXTRACT
;***************Read control data in structure c**********************
read_control,c
printl,c.log,'RUNNING PROCEDURE:Arc
;********print list of files to analyse to screen and log file********
if c.narc eq 1 then printl,c.log,'For file number '+strtrim(c.arcfile,2)
if c.narc eq 2 then printl,c.log,'For file numbers '+$
   strtrim(c.darc(0),2)+' and '+strtrim(c.darc(1),2)
;******read header  of first arc file in list*************************
read_data,c.arcfile,c,h,f,dummy
;**********************Check file type********************************
if not strcmp(strtrim(h.obstype,2),'ARC')  then $
printl,c.log,'FATAL ERROR: incorrect file type, file type is '+h.obstype
if not strcmp(strtrim(h.obstype,2),'ARC') then stop
;**********get intermediate spectra for specified arc file(s)*********
for k = 0,c.narc-1 do if not keyword_set(noextract) then begin
;***************Calling extr_file*************************************
;Input:  arcfile number
;        number of iterations for optimal extraction routine (0)
;Output: header information relating to arcfile image (h,f)
;        array (spectra) containing intermediate spectra vs pixel number
   extr_file,c.darc(k),0,h,f,spectra
;*******save intermediate spectra to file (a1234567.fit)*************
   write_file,c.pdir+c.pint+'a'+strtrim(c.darc(k),2),c,h,f,spectra
endif
;
;*******Read header and intermediate spectra of first arc spectra****
read_file,c.pdir+c.pint+'a'+strtrim(c.arcfile,2),c,h,f,spectra
;***In case when two arcfiles are specified read data for second*****
if c.narc eq 2 then begin
   read_file,c.pdir+c.pint+'a'+strtrim(c.darc(1),2),c,hh,f,dummy
;*********update parameter h.lamp in header data*********************
   h.lamp = strmid(h.lamp,0,2)+'_'+strmid(hh.lamp,0,2)
;**********print note to screen and log file*************************
   printl,c.log,'Combining extracted arc spectra for lamp type '+h.lamp
;******combine two arcfiles as specified in user manual**************
;******first part (up to pixel c.afilecut taken from arcfile 1*******
;******remainder taken from arcfile 2********************************
   spectra(*,c.afilecut:c.ymax/c.ybin-1) = dummy(*,c.afilecut:c.ymax/c.ybin-1)
;*save intermediate spectra of combined arcfile to file (a1234567.fit)*
   write_file,c.pdir+c.pint+'a'+strtrim(c.arcfile,2),c,h,f,spectra
endif
;*****************Calling Atlas (if using option Arc,/Atlas)*********
;Function:Run GUI to edit arcline data in control file
;         Select the line  the arc spectra used to calculate y-offsets
;         Select the  Atlas file name and common wavelength range
;         Select  the wavelength and pixel position of calibration lines
if keyword_set(atlas) then atlas
;****************************calibrate arc lines**********************
;***************Read control data in structure c**********************
read_control,c
;****set plot window used by following subroutines********************
window,xsize=fix(0.7*c.psize),ysize=fix(0.7*c.psize)
!P.MULTI = [0,1,5,0,0]  & !P.CHARSIZE=2
;***************Calling arc_offset*************************************
;Input:  arcfile header and intermediate spectra (c,h,f,spectra)
;Output: yoff - relative offset of individual arc spectra in pixels found
;               by comparing position of a selected line in the spectra
arc_offset,c,h,f,spectra,yoff
;***************Calling arc_cal****************************************
;Input:  arcfile header and intermediate arc spectra (c,h,f,spectra)
;        yoff - relative offset of individual arc spectra
;Output: wavelength calibration added data array of arc spectra (spectra)
;        using polynomial fit of wavelength vs pixel number
;        array of offsets between calibration data and polynomial fits (del)
;        limits of common wavelength range found from spectra (wlmin,wlmax)
arc_cal,c,h,f,spectra,yoff,del,wlmin,wlmax
;****Save Image of plots of calibration process to log file arc.gif****
write_gif,c.pdir+c.plog+'Arc.gif',TVRD()
;**************Output arcfile and log data*****************************
;*******save intermediate spectra to file (s1234567.fit)***************
write_file,c.pdir+c.pint+'a'+strtrim(c.arcfile,2),c,h,f,spectra
end
;***print summary data to log file and screen**************************
printl,c.log,'New Arc file created:a'+strtrim(c.arcfile,2)
printl,c.log,'Lamp '+strtrim(h.lamp,2)+'  max delta for fit '$
  +string(max(abs((del))),format='(f6.3)')+' pixels'
printl,c.log,'Common wavelength range '+string(wlmin,format='(f8.1)')$
  + ' to '+string(wlmax,format='(f8.1)')+' A'
;**save table max/min wavelength and fit data (del)to file arc.txt*****
openw,nw,c.pdir+c.plog+'Arc.txt',/get_lun
printf,nw,'#Fiber min_wavelength  max_wavelength  delta_fit_lines'
for i = 0,c.nfiber-1 do if f(i).line gt 0 and f(i).type ne 'X' then $
  printf,nw,i,spectra(f(i).line*8-8,0),spectra(f(i).line*8-8,c.ymax/c.ybin-1)$
  ,del(i,*),format='(i6,2f15.3,20f7.3)'
close,nw  &  free_lun,nw
;*************Check specified wavelength range*************************
if wlmin gt c.wlmin then printl,c.log,$
     'ERROR: specified minimum wavelength less than actual mimimum'
if wlmax lt c.wlmax then printl,c.log,$
     'ERROR: specified maximum wavelength greater than actual maximum'
index = where(f.type ne 'X' and f.line gt 0,nfiber)
;****get mean and rms fit of polynomial for each calibration line********
meandel = total(del,1)/float(nfiber)
rmsdel  = sqrt(total(del*del,1)/float(nfiber))
;*Print fit statistics for calibration lines used to screen and log file
printl,c.log,'Arcline  wavelength  mean_delta_fit  rms_delta_fit'
j = 0
for i = 0,c.narcline-1 do if c.aflag(i) eq 1 then begin
   printl,c.log,string(i+1,format='(i6)')+string(c.acalwl(i),format='(f13.3)')+$
     string(meandel(j),format='(f13.3)')+string(rmsdel(j),format='(f13.3)')
   j = j+1
endif
end
